 /*
 * ResourceGroupMembershipListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.ResourceGroupMembership;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.ResourceGroupMembershipDTO;

 import java.util.ArrayList;
 import java.util.List;
 import java.util.Locale;

/**
 * Montador de lista de grupos de recursos.
 * 
 * @author Patrezze - YMPD
 * @since 3.0
 * @version 1.0
 *
 */
public class ResourceGroupMembershipListMounter {

    /**
     * Monta uma lista de grupo de recursos a partir de uma lista de grupo de
     * recursos de transferncia.
     * 
     * @param resourceGroupMembershipListDTO Lista de grupo de recursos de transferncia.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportador pelos sistema.
     * @return Lista de grupo de recursos.
     */
    public static List<ResourceGroupMembership> mountLocalObjectList(
            List<Object> resourceGroupMembershipListDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        if (resourceGroupMembershipListDTO == null) {
            return null;
        } else {
            List<ResourceGroupMembership> resourceGroupMembershipList = new ArrayList<ResourceGroupMembership>();

            for (Object objectResourceGroupMembershipDTO : resourceGroupMembershipListDTO) {
                ResourceGroupMembershipDTO resourceGroupMembershipDTO = (ResourceGroupMembershipDTO) objectResourceGroupMembershipDTO;
                resourceGroupMembershipList.add(ResourceGroupMembershipMounter
                        .mountLocalObject(resourceGroupMembershipDTO,
                                preferredUserLanguage,
                                supportedApplicationLanguages));
            }

            return resourceGroupMembershipList;
        }
    }
}
