/*
 * RoleAdministrationAuthorizationListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.access.RoleAdministrationAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleAdministrationAuthorizationDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RoleAdministrationAuthorizationListMounter {

     /**
     * Monta uma lista de papel a partir de uma lista de papel de transferncia.
     * @param roleListDTO Lista de papel de transferncia.
     * @return Lista de papel.
     */
    public static List<RoleAdministrationAuthorization> mountLocalObjectList (List<Object> roleListDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages  )
    {
        if (roleListDTO == null ) { return null; }
        else
        {
            List<RoleAdministrationAuthorization> roleList = new ArrayList<RoleAdministrationAuthorization> ();

            for (Object objectRoleDTO : roleListDTO) {
                RoleAdministrationAuthorizationDTO roleDTO = (RoleAdministrationAuthorizationDTO)objectRoleDTO;
                roleList.add(RoleAdministrationAuthorizationMounter.mountLocalObject(roleDTO, preferredUserLanguage, supportedApplicationLanguages));
            }
            
            return roleList;
        }
    }
    
}

