/*
 * RoleResourceAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.access.RoleResourceAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleResourceAuthorizationDTO;

import java.util.List;
import java.util.Locale;

public class RoleResourceAuthorizationMounter {

    /**
     * Monta um autorizao de papel em recurso a partir de uma
     * autorizao de papel em recurso de transferncia.
     * 
     * @param roleResourceAuthorizationDTO
     *            Autorizao de papel em recurso de transferncia.
     * @param preferredUserLanguage
     * @param supportedApplicationLanguages
     * @return Autorizao de papel em recurso.
     */
    public static RoleResourceAuthorization mountLocalObject(
            RoleResourceAuthorizationDTO roleResourceAuthorizationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (roleResourceAuthorizationDTO == null) {
            return null;
        } else {
            RoleResourceAuthorization roleResourceAuthorization = new RoleResourceAuthorization();

            // Montagem simples.
            roleResourceAuthorization
                    .setUid(roleResourceAuthorizationDTO.getUid());

            // Montagem complexa.
            roleResourceAuthorization.setRole(RoleMounter
                    .mountLocalObject(roleResourceAuthorizationDTO
                            .getRole(), preferredUserLanguage,
                            supportedApplicationLanguages));
            
            roleResourceAuthorization.setResource(ResourceMounter
                    .mountLocalObject(roleResourceAuthorizationDTO
                            .getResource(), preferredUserLanguage,
                            supportedApplicationLanguages));

            return roleResourceAuthorization;
        }
    }    
}

