/*
* @(#)RoleUseCaseAuthorizationListMounter.java
*
*/
/*
 * RoleUseCaseAuthorizationListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.configuration.RoleUseCaseAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleUseCaseAuthorizationDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * TODO Comentar.
 *
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 *
 */
public class RoleUseCaseAuthorizationListMounter {

    /**
     * Monta uma lista de autorizaes de papel em caso de uso a partir de uma
     * lista de autorizaes de papel em caso de uso de transferncia.
     * 
     * @param roleUseCaseAuthorizationListDTO
     *            Lista de autorizaes de papel em caso de uso de
     *            transferncia.
     * @param preferredUserLanguage
     * @param supportedApplicationLanguages
     * @return Lista de autorizaes de papel em caso de uso.
     */
    public static List<RoleUseCaseAuthorization> mountLocalObjectList(
            List<Object> roleUseCaseAuthorizationListDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages  ) {

        if (roleUseCaseAuthorizationListDTO == null ) { return null; }
        else
        {
            List<RoleUseCaseAuthorization> roleUseCaseAuthorizationList = new ArrayList<RoleUseCaseAuthorization> ();

            for (Object objectRoleUseCaseAuthorizationDTO : roleUseCaseAuthorizationListDTO) {
                RoleUseCaseAuthorizationDTO roleUseCaseAuthorizationDTO = (RoleUseCaseAuthorizationDTO) objectRoleUseCaseAuthorizationDTO;
                roleUseCaseAuthorizationList.add(RoleUseCaseAuthorizationMounter.mountLocalObject(roleUseCaseAuthorizationDTO, preferredUserLanguage, supportedApplicationLanguages));
            }
            
            return roleUseCaseAuthorizationList;
        }
    }

}

