/*
 * TechnologyListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Technology;
import br.com.petrobras.security.server.service.soap.TechnologyDTO;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TechnologyListMounter implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 6211444999187352961L;

    public static List<Technology> mountLocalObject(List<TechnologyDTO> technologyListDTO)
    {
        if (technologyListDTO == null) { return null; }
        else
        {
            List<Technology> technologyList = new ArrayList<Technology>();

            for (TechnologyDTO technologyDTO : technologyListDTO)
            {  
                technologyList.add(TechnologyMounter.mountLocalObject(technologyDTO));
            }

            return technologyList;
        }
    }
    
    public static List<TechnologyDTO> mountTransferObject(List<Technology> technologyList)
    {
        if (technologyList == null) { return null; }
        else
        {
            ArrayList<TechnologyDTO> technologyListDTO = new ArrayList<TechnologyDTO>();

            for (Technology technology : technologyList) {
                technologyListDTO.add(TechnologyMounter.mountTransferObject(technology));
            }

            return technologyListDTO;
        }
    }
    
}

