/*
 * Decompiled with CFR 0.152.
 */
package csbase.login;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPSocketFactory;
import csbase.logic.User;
import csbase.server.plugin.service.loginservice.ILoginService;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import tecgraf.javautils.core.properties.PropertiesUtils;
import tecgraf.javautils.core.properties.PropertyException;

public class LDAPLoginProtocol
implements ILoginService {
    Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    public static final int LDAP_DEFAULT_PORT = 389;
    public static final String LDAP_PATTERN_USER = "[%U]";
    private List<String> LDAPServers;
    private Vector<Integer> LDAPPorts;
    private List<String> LDAPPatternList;
    private String LDAPCharSet;
    private Boolean sslEnabled;
    private String keyStorePath;
    private String keyStorePassword;
    private int LDAPTimeout;

    public ILoginService.LoginProtocol getProtocolType() {
        return ILoginService.LoginProtocol.PROTOCOL_LDAP;
    }

    public void setProperties(Properties properties) {
        try {
            this.sslEnabled = PropertiesUtils.getBoolenValue((Properties)properties, (String)"LDAPSSLEnabled");
            if (this.sslEnabled.booleanValue()) {
                this.keyStorePath = PropertiesUtils.getValue((Properties)properties, (String)"LDAPKeyStorePath");
                this.keyStorePassword = PropertiesUtils.getValue((Properties)properties, (String)"LDAPKeyStorePassword");
            }
            this.LDAPServers = PropertiesUtils.getValuesList((Properties)properties, (String)"LDAPServer");
            int size = this.LDAPServers.size();
            if (size == 0) {
                throw new PropertyException("Nenhum servidor LDAP definido para autentica\u00e7\u00e3o!");
            }
            this.LDAPPorts = new Vector();
            for (int i = 1; i <= this.LDAPServers.size(); ++i) {
                this.LDAPPorts.add(PropertiesUtils.getIntValue((Properties)properties, (String)("LDAPPort." + i)));
            }
            this.LDAPPatternList = PropertiesUtils.getValuesList((Properties)properties, (String)"LDAPPattern");
            this.LDAPCharSet = PropertiesUtils.getValue((Properties)properties, (String)"LDAPCharSet");
            this.LDAPTimeout = PropertiesUtils.getIntValue((Properties)properties, (String)"LDAPConnectionTimeout");
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User authenticate(User user, String password) {
        byte[] passwd = null;
        try {
            passwd = password.getBytes(this.LDAPCharSet);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.log(Level.SEVERE, String.format("LDAPCharSet n\u00e3o suportado: %s.", this.LDAPCharSet), e);
            return null;
        }
        ArrayList<String> distinguishedNameList = new ArrayList<String>(this.LDAPPatternList.size());
        for (String pattern : this.LDAPPatternList) {
            pattern = pattern.replace(LDAP_PATTERN_USER, user.getLogin());
            distinguishedNameList.add(pattern);
        }
        int i = 0;
        while (i < this.LDAPServers.size()) {
            block23: {
                LDAPConnection conn;
                String server;
                block25: {
                    Object keyStorePass;
                    block24: {
                        server = this.LDAPServers.get(i);
                        int port = this.LDAPPorts.get(i);
                        conn = null;
                        if (this.sslEnabled.booleanValue()) {
                            LDAPJSSESecureSocketFactory ssf = null;
                            try {
                                SSLContext context = SSLContext.getInstance("TLS", "SunJSSE");
                                FileInputStream keyStoreIStream = null;
                                keyStorePass = null;
                                if (this.keyStorePassword != null && !this.keyStorePassword.equals("")) {
                                    keyStorePass = this.keyStorePassword.toCharArray();
                                }
                                keyStoreIStream = new FileInputStream(this.keyStorePath);
                                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                                keyStore.load(keyStoreIStream, (char[])keyStorePass);
                                TrustManager[] tms = new TrustManager[]{new LDAPTrustManager(keyStore)};
                                context.init(null, tms, null);
                                ssf = new LDAPJSSESecureSocketFactory(context.getSocketFactory());
                            }
                            catch (Exception e) {
                                this.logger.info(String.format("Certificado LDAP n\u00e3o encontrado no keystore padr\u00e3o %s:%d [%s].", server, port, e.getMessage()));
                                break block23;
                            }
                            conn = new LDAPConnection((LDAPSocketFactory)ssf);
                        } else {
                            conn = new LDAPConnection(this.LDAPTimeout * 1000);
                        }
                        LDAPConstraints constraints = conn.getConstraints();
                        constraints.setTimeLimit(this.LDAPTimeout * 1000);
                        conn.setConstraints(constraints);
                        try {
                            conn.connect(server, port);
                        }
                        catch (LDAPException e) {
                            this.logger.info(String.format("Conex\u00e3o rejeitada pelo servidor %s:%d [%s].", server, port, e.resultCodeToString()));
                            break block23;
                        }
                        try {
                            for (String distinguishedName : distinguishedNameList) {
                                try {
                                    conn.bind(3, distinguishedName, passwd);
                                    if (conn.getAuthenticationDN() == null) continue;
                                    keyStorePass = user;
                                    break block24;
                                }
                                catch (LDAPException e) {
                                    this.logger.log(Level.SEVERE, String.format("%s rejeitado pelo servidor %s [%s].", distinguishedName, server, e.resultCodeToString()), e);
                                }
                            }
                            break block25;
                        }
                        catch (Throwable throwable) {
                            try {
                                conn.disconnect();
                                throw throwable;
                            }
                            catch (LDAPException e) {
                                this.logger.info(String.format("Erro ao desconectar do servidor %s [%s]", server, e.resultCodeToString()));
                            }
                            throw throwable;
                        }
                    }
                    try {
                        conn.disconnect();
                        return keyStorePass;
                    }
                    catch (LDAPException e) {
                        this.logger.info(String.format("Erro ao desconectar do servidor %s [%s]", server, e.resultCodeToString()));
                    }
                    return keyStorePass;
                }
                try {
                    conn.disconnect();
                }
                catch (LDAPException e) {
                    this.logger.info(String.format("Erro ao desconectar do servidor %s [%s]", server, e.resultCodeToString()));
                }
            }
            ++i;
        }
        return null;
    }

    private class LDAPTrustManager
    implements X509TrustManager {
        private KeyStore keyStore;

        public LDAPTrustManager(KeyStore keyStore) {
            this.keyStore = keyStore;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String arg1) throws CertificateException {
            boolean trusted = this.isChainTrusted(chain);
            if (!trusted) {
                throw new CertificateException("Cliente n\u00e3o \u00e9 confi\u00e1vel");
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String arg1) throws CertificateException {
            boolean trusted = this.isChainTrusted(chain);
            if (!trusted) {
                throw new CertificateException("Servidor n\u00e3o \u00e9 confi\u00e1vel");
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] X509Certs = null;
            try {
                int numberOfEntry = this.keyStore.size();
                if (numberOfEntry > 0) {
                    X509Certs = new X509Certificate[numberOfEntry];
                    Enumeration<String> aliases = this.keyStore.aliases();
                    int i = 0;
                    while (aliases.hasMoreElements()) {
                        X509Certs[i] = (X509Certificate)this.keyStore.getCertificate(aliases.nextElement());
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                LDAPLoginProtocol.this.logger.info(String.format("Erro ao listar certificados do keystore [%s].", e.getMessage()));
                X509Certs = null;
            }
            return X509Certs;
        }

        private boolean isChainTrusted(X509Certificate[] chain) {
            boolean trusted = false;
            try {
                for (int i = chain.length - 1; i >= 0; --i) {
                    if (this.keyStore.getCertificateAlias(chain[i]) == null) continue;
                    trusted = true;
                    break;
                }
            }
            catch (Exception e) {
                LDAPLoginProtocol.this.logger.info(String.format("Keystore inv\u00e1lida [%s].", e.getMessage()));
                trusted = false;
            }
            return trusted;
        }
    }
}

