/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import ibase.common.ServiceUtil;
import ibase.rest.model.algorithm.v1.Requirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.json.JSONArray;

public class RequirementsBuilder {
    public static final String RESOURCE_BUNDLE = "RequirementsBuilder";
    public final List<Requirement> requirements;
    private Locale locale;
    private static final String CPU_KEY = "cpu";
    private static final String MEMORY_KEY = "memory";
    private static final String PLATFORMS_KEY = "platforms";
    private static final String REQUIREMENTS_KEY = "requirements";

    private ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    public RequirementsBuilder(String algorithmId, AlgorithmVersionId algoVersionId, Locale currentLocale) {
        this.locale = currentLocale;
        this.requirements = new ArrayList<Requirement>();
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        try {
            AlgorithmVersionInfo versionInfo;
            Vector supportedPlatforms;
            AlgorithmInfo algoInfo = service.getInfo((Object)algorithmId);
            Hashtable propertyValues = algoInfo.getPropertyValues();
            if (propertyValues != null) {
                ArrayList requirements = new ArrayList();
                propertyValues.forEach((k, v) -> this.loadRequirement((String)k, (String)v));
            }
            if ((supportedPlatforms = (versionInfo = algoInfo.getVersionInfo((Object)algoVersionId)).getSupportedPlatforms()) != null) {
                JSONArray plats = new JSONArray();
                supportedPlatforms.stream().forEach(p -> plats.put(p));
                this.loadRequirement(PLATFORMS_KEY, plats.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadRequirement(String key, String value) {
        String name = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(this.locale)).message(key, new String[0]);
        switch (key) {
            case "cpu": 
            case "memory": {
                Double.parseDouble(value);
                this.requirements.add(this.buildRequirement(key, name, Double.parseDouble(value), Requirement.TypeEnum.DOUBLE, false));
                break;
            }
            case "requirements": {
                Arrays.stream(value.split(",")).forEach(v -> this.requirements.add(this.buildRequirement((String)v, (String)v, true, Requirement.TypeEnum.BOOLEAN, false)));
                break;
            }
            case "platforms": {
                this.requirements.add(this.buildRequirement(key, name, value, Requirement.TypeEnum.ENUMERATION, true));
            }
        }
    }

    private Requirement buildRequirement(String key, String name, Object value, Requirement.TypeEnum type, boolean editable) {
        Requirement req = new Requirement();
        req.setKey(key);
        req.setName(name);
        req.setValue(value);
        req.setType(type);
        req.setEditable(Boolean.valueOf(editable));
        return req;
    }
}

