package Requests.User;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class User   {
	private String id = null;
	private String name = null;
	private String login = null;
	private String avatar = null;
	private List<String> roles = new ArrayList<String>();
	public User id(String id) {
		this.id = id;
		return this;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public User name(String name) {
		this.name = name;
		return this;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public User login(String login) {
		this.login = login;
		return this;
	}
	public String getLogin() {
		return login;
	}
	public void setLogin(String login) {
		this.login = login;
	}
	public User avatar(String avatar) {
		this.avatar = avatar;
		return this;
	}
	public String getAvatar() {
		return avatar;
	}
	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}
	public User roles(List<String> roles) {
		this.roles = roles;
		return this;
	}
	public User addRolesItem(String rolesItem) {
		this.roles.add(rolesItem);
		return this;
	}
	public List<String> getRoles() {
		return roles;
	}
	public void setRoles(List<String> roles) {
		this.roles = roles;
	}

	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		User user = (User) o;
		return Objects.equals(this.id, user.id) &&
				Objects.equals(this.name, user.name) &&
				Objects.equals(this.login, user.login) &&
				Objects.equals(this.avatar, user.avatar) &&
				Objects.equals(this.roles, user.roles);
	}

	@Override
	public int hashCode() {
		return Objects.hash(id, name, login, avatar, roles);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class User {\n");
		sb.append("    id: ").append(toIndentedString(id)).append("\n");
		sb.append("    name: ").append(toIndentedString(name)).append("\n");
		sb.append("    login: ").append(toIndentedString(login)).append("\n");
		sb.append("    avatar: ").append(toIndentedString(avatar)).append("\n");
		sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}


