/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.drmaa2.v1;

import csbase.logic.CommandInfo;
import csbase.logic.User;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.sgaservice.SGAService;
import ibase.rest.api.drmaa2.v1.adapter.JobDAO;
import ibase.rest.api.drmaa2.v1.adapter.JobMonitorListener;
import ibase.rest.model.drmaa2.v1.Job;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.Executors;

public class JobInfoMonitor {
    private JobDAO jobDAO = null;
    private Collection<JobMonitorListener> jobsListener = Collections.synchronizedList(new ArrayList());
    private final Object listenerLock = new Object();
    private Runnable UpdateJobInfoThread = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = JobInfoMonitor.this.listenerLock;
                synchronized (object) {
                    while (JobInfoMonitor.this.jobsListener.isEmpty()) {
                        try {
                            JobInfoMonitor.this.listenerLock.wait();
                        }
                        catch (InterruptedException e) {
                            Server.logSevereMessage((String)"Erro no wait", (Throwable)e);
                        }
                    }
                }
                Service.setUserId((Object)User.getAdminId());
                Vector infos = SGAService.getInstance().getAllSGACommands();
                LinkedList<Job> jobs = new LinkedList<Job>();
                for (CommandInfo info : infos) {
                    Job job;
                    if (info.getProgressData() == null || (job = JobInfoMonitor.this.jobDAO.findJobById(info.getId())) == null || info.getProgressData().getDescription().equals(job.getProgressInfo())) continue;
                    job.setProgressInfo(info.getProgressData().getDescription());
                    job.setLastModifiedTime(LocalDateTime.now().toString());
                    JobInfoMonitor.this.jobDAO.updateJob(job);
                    jobs.add(job);
                }
                if (!jobs.isEmpty()) {
                    ArrayList copy = new ArrayList();
                    Iterator iterator = JobInfoMonitor.this.listenerLock;
                    synchronized (iterator) {
                        copy.addAll(JobInfoMonitor.this.jobsListener);
                    }
                    for (JobMonitorListener l : copy) {
                        try {
                            l.infoChanged(jobs);
                        }
                        catch (Exception e) {
                            Server.logSevereMessage((String)"Erro na notifica\u00e7\u00e3o do infoChanged", (Throwable)e);
                        }
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                }
            }
        }
    };

    public JobInfoMonitor(JobDAO jobDAO) {
        this.jobDAO = jobDAO;
        Executors.newSingleThreadExecutor().execute(this.UpdateJobInfoThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobMonitorListener(JobMonitorListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.jobsListener.add(listener);
            this.listenerLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobMonitorListener(JobMonitorListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.jobsListener.remove(listener);
        }
    }
}

