package Requests.Jobs;

import java.util.Objects;
import java.util.ArrayList;
import java.util.List;


/**
 * MonitoredFile
 */
public class MonitoredFile   {
  private String name = null;

  private String id = null;

  private List<String> formats = new ArrayList<String>();

  public MonitoredFile name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public MonitoredFile id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public MonitoredFile formats(List<String> formats) {
    this.formats = formats;
    return this;
  }

  public MonitoredFile addFormatsItem(String formatsItem) {
    this.formats.add(formatsItem);
    return this;
  }

   /**
   * Get formats
   * @return formats
  **/
  public List<String> getFormats() {
    return formats;
  }

  public void setFormats(List<String> formats) {
    this.formats = formats;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MonitoredFile monitoredFile = (MonitoredFile) o;
    return Objects.equals(this.name, monitoredFile.name) &&
        Objects.equals(this.id, monitoredFile.id) &&
        Objects.equals(this.formats, monitoredFile.formats);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, id, formats);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MonitoredFile {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    formats: ").append(toIndentedString(formats)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

