package Requests.Projects;

import Requests.Authentication.InvalidLoginOrPasswordException;
import Requests.Authentication.Token;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

import javax.ws.rs.client.*;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.Normalizer;
import java.util.Base64;
import java.util.regex.Pattern;

public class FileExplorer {

	private static final Pattern DIACRITICS_AND_FRIENDS = Pattern
			.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");

	public static FileUpload uploadFile(String host, Token token, Project project, String projectFolderPath,
			String localFilePath, String fileName) throws ProjectOrFileNotFoundException, PermissionException {
		FileDataBodyPart filePart = new FileDataBodyPart("file", new File(localFilePath));
		MultiPart multipartEntity = null;
		FormDataMultiPart form = null;
		try {
			Client client = ClientBuilder.newClient();
			WebTarget webTarget = client.target(host).register(MultiPartFeature.class);
			filePart.setContentDisposition(FormDataContentDisposition.name("file")
					.fileName(fileName).build());
			form = new FormDataMultiPart();
			form.field("uploadType", "multipart");
			multipartEntity = form.bodyPart(filePart);
			Response response = webTarget.path("projects").path(project.getId()).path("files").path
					(projectFolderPath).request("application/json;charset=UTF-8").header(HttpHeaders
					.AUTHORIZATION, "Bearer " + token.getAccessToken()).post(Entity.entity
					(multipartEntity, MediaType.MULTIPART_FORM_DATA));
			return response.readEntity(FileUpload.class);
		} finally {
			if (multipartEntity != null) {
				try {
					multipartEntity.close();
				} catch (IOException e) {
				}
				multipartEntity = null;
			}
			if (form != null) {
				try {
					form.close();
				} catch (IOException e) {
				}
				form = null;
			}
		}
	}

	private static String validateFileName(String fileName) {
		return stripDiacritics(fileName.replaceAll("[ \"\'!@#$%¨&*()+`´{}^~:;?/°><,|\\[\\]\\\\]", ""));

	}

	private static String stripDiacritics(String str) {
		str = Normalizer.normalize(str, Normalizer.Form.NFD);
		str = DIACRITICS_AND_FRIENDS.matcher(str).replaceAll("");
		return str;
	}

	public static String downloadTextFile(String host, Token token, Project project, String projectFolderPath,
			String fileName)
			throws ProjectOrFileNotFoundException, PermissionException, InvalidLoginOrPasswordException {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(host);
		String fileId = Base64.getEncoder().encodeToString(projectFolderPath.equals("root") ? fileName.getBytes()
				: (projectFolderPath + (fileName == null ? "" : "/" + fileName)).getBytes());
		WebTarget uploadTarget = webTarget.path("projects").path(project.getId()).path("files").path(fileId);

		Invocation.Builder invocationBuilder = uploadTarget.request();

		Response response = invocationBuilder
				.header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken()).get();

		int status = response.getStatus();

		if (status == Response.Status.OK.getStatusCode())
			return response.readEntity(String.class);
		else if (status == Response.Status.BAD_REQUEST.getStatusCode())
			throw new InvalidLoginOrPasswordException();
		else if (status == Response.Status.FORBIDDEN.getStatusCode())
			throw new PermissionException();
		else if (status == Response.Status.NOT_FOUND.getStatusCode())
			throw new ProjectOrFileNotFoundException();
		client.close();
		return null;
	}

  public static InputStream downloadBinaryFile(String host, Token token, Project project, String projectFolderPath,
      String fileName)
      throws ProjectOrFileNotFoundException, PermissionException, InvalidLoginOrPasswordException {
    Client client = ClientBuilder.newClient();
    WebTarget webTarget = client.target(host);
    String fileId = Base64.getEncoder().encodeToString(projectFolderPath.equals("root") ? fileName.getBytes()
        : (projectFolderPath + (fileName == null ? "" : "/" + fileName)).getBytes());
    WebTarget uploadTarget = webTarget.path("projects").path(project.getId()).path("files").path(fileId);

    Invocation.Builder invocationBuilder = uploadTarget.request();

    Response response = invocationBuilder
        .header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken()).get();

    int status = response.getStatus();

    if (status == Response.Status.OK.getStatusCode())
      return response.readEntity(InputStream.class);
    else if (status == Response.Status.BAD_REQUEST.getStatusCode())
      throw new InvalidLoginOrPasswordException();
    else if (status == Response.Status.FORBIDDEN.getStatusCode())
      throw new PermissionException();
    else if (status == Response.Status.NOT_FOUND.getStatusCode())
      throw new ProjectOrFileNotFoundException();
    client.close();
    return null;
  }

	public static void downloadLargeFile(String host, Token token, Project project, String projectFolderPath,
			String fileName, String destinFileName)
			throws ProjectOrFileNotFoundException, PermissionException, InvalidLoginOrPasswordException {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(host);
		String fileId = Base64.getEncoder().encodeToString(projectFolderPath.equals("root") ? fileName.getBytes()
				: (projectFolderPath + (fileName == null ? "" : "/" + fileName)).getBytes());
		WebTarget uploadTarget = webTarget.path("projects").path(project.getId()).path("files").path(fileId)
				.path("link");

		Invocation.Builder invocationBuilder = uploadTarget.request("application/json;charset=UTF-8");
		Response response = invocationBuilder
				.header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken()).get();

		int status = response.getStatus();

		if (status == Response.Status.OK.getStatusCode()) {
			FileLink link = response.readEntity(FileLink.class);
			URL website;
			try {
				File file = new File(destinFileName);
        if (file.getParentFile() != null) {
          file.getParentFile().mkdirs();
        }
				file.createNewFile();
				website = new URL(link.getUrl());
				ReadableByteChannel rbc = Channels.newChannel(website.openStream());
				FileOutputStream fos = new FileOutputStream(destinFileName);
				fos.getChannel().transferFrom(rbc, 0, Long.MAX_VALUE);
				fos.close();
			} catch (MalformedURLException e) {
				e.printStackTrace();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}

		} else if (status == Response.Status.BAD_REQUEST.getStatusCode())
			throw new InvalidLoginOrPasswordException();
		else if (status == Response.Status.FORBIDDEN.getStatusCode())
			throw new PermissionException();
		else if (status == Response.Status.NOT_FOUND.getStatusCode())
			throw new ProjectOrFileNotFoundException();
	}

  public static void removeFile(String host, Token token, Project project, String projectFolderPath, String fileName)
    throws ProjectOrFileNotFoundException, PermissionException, InvalidLoginOrPasswordException {
    Client client = ClientBuilder.newClient();
    WebTarget webTarget = client.target(host);
    String fileId = Base64.getEncoder().encodeToString(projectFolderPath.equals("root") ? fileName.getBytes()
        : (projectFolderPath + (fileName == null ? "" : "/" + fileName)).getBytes());
    WebTarget uploadTarget = webTarget.path("projects").path(project.getId()).path("files").path(fileId);

    Invocation.Builder invocationBuilder = uploadTarget.request();

    Response response = invocationBuilder
        .header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken()).delete();

    int status = response.getStatus();

    if (status == Response.Status.BAD_REQUEST.getStatusCode())
      throw new InvalidLoginOrPasswordException();
    else if (status == Response.Status.FORBIDDEN.getStatusCode())
      throw new PermissionException();
    else if (status == Response.Status.NOT_FOUND.getStatusCode())
      throw new ProjectOrFileNotFoundException();
    client.close();
  }
}
