/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.project.v1;

import csbase.exception.InfoException;
import csbase.exception.ServiceFailureException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import csbase.rest.adapter.project.v1.CSBaseProject;
import csbase.rest.adapter.project.v1.CSBaseProjectFile;
import csbase.rest.adapter.project.v1.CSBaseProjectInfo;
import ibase.common.NotFoundException;
import ibase.exception.InternalServiceException;
import ibase.exception.InvalidParameterException;
import ibase.rest.api.project.v1.adapter.Project;
import ibase.rest.api.project.v1.adapter.ProjectFile;
import ibase.rest.api.project.v1.adapter.ProjectInfo;
import ibase.rest.api.project.v1.adapter.ProjectService;
import ibase.rest.api.project.v1.adapter.SharingType;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;

public class CSBaseProjectServiceImpl
implements ProjectService {
    public Project createProject(String name, String userId, String description, String type, SharingType sharingType) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        CommonProjectInfo projectInfo = new CommonProjectInfo();
        projectInfo.userId = userId;
        projectInfo.description = description;
        if (type != null) {
            projectInfo.setAttribute("ibase_project_type", (Object)type);
        }
        projectInfo.name = name;
        try {
            CommonClientProject project = service.createProject(projectInfo);
            if (sharingType != null) {
                this.setCSBaseSharingType(project.getId(), sharingType, project.getUsersRO(), project.getUsersRW());
            }
            return new CSBaseProject(project);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public Project updateProject(String projectId, String description, String type, SharingType sharingType) {
        try {
            ProjectServiceInterface service = ClientRemoteLocator.projectService;
            CommonClientProject project = service.openProject((Object)projectId, false);
            if (description != null) {
                project.setDescription(description);
                project.modify();
            }
            if (type != null) {
                project.setAttribute("ibase_project_type", (Object)type);
                project.modify();
            }
            if (sharingType != null) {
                Set usersRO = project.getUsersRO();
                Set usersRW = project.getUsersRW();
                this.setCSBaseSharingType(project.getId(), sharingType, usersRO, usersRW);
            }
            return new CSBaseProject(project);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InternalServiceException(e);
        }
    }

    public Project getProject(String projectId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            CommonClientProject project = service.openProject((Object)projectId, false);
            return new CSBaseProject(project);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public ProjectFile getProjectFile(String projectId, String fileId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            ClientProjectFile file = service.getChild((Object)projectId, new String[]{fileId});
            return new CSBaseProjectFile(file);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<ProjectInfo> getProjectsSharedWith(String userId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            List infos = service.getProjectsSharedWithUser((Object)userId);
            return this.filter(infos);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<ProjectInfo> getAllProjects(String userId) {
        ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
        AdministrationServiceInterface adminService = ClientRemoteLocator.administrationService;
        try {
            List users = adminService.getAllUsers();
            ArrayList<UserProjectInfo> allProjects = new ArrayList<UserProjectInfo>();
            for (User user : users) {
                allProjects.addAll(projectService.getProjectsFromUser(user.getId()));
            }
            return this.filter(allProjects);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<ProjectInfo> getProjectsCreatedBy(String userId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            List infos = service.getProjectsFromUser((Object)userId);
            return this.filter(infos);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void removeProject(String projectId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            service.removeProject((Object)projectId);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public boolean existsProjectFile(String projectId, String fileId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            String[] path = fileId.split(File.separator);
            return service.existsFile((Object)projectId, path);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void copyFile(String sourceProjectId, String sourceFileId, String targetProjectId, String targetFileId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            String[] sourceFilePath = sourceFileId.split(File.separator);
            String[] targetDirPath = targetFileId.split(File.separator);
            service.copyFile((Object)sourceProjectId, sourceFilePath, (Object)targetProjectId, targetDirPath);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void moveFile(String sourceProjectId, String sourceFileId, String targetProjectId, String targetFileId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            String[] sourceFilePath = sourceFileId.split(File.separator);
            String[] targetDirPath = targetFileId.split(File.separator);
            service.moveFile((Object)sourceProjectId, sourceFilePath, (Object)targetProjectId, targetDirPath);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public ProjectFile renameFile(String projectId, String fileId, String name) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            String[] path = fileId.split(File.separator);
            service.renameFile((Object)projectId, path, name);
            path[path.length - 1] = name;
            ClientProjectFile newFile = service.getChild((Object)projectId, path);
            return new CSBaseProjectFile(newFile);
        }
        catch (ServiceFailureException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public ProjectFile createFolder(String projectId, String fileId, String folderName) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            ProjectFile targetFolder = this.getProjectFile(projectId, fileId);
            String folderPath = String.join((CharSequence)File.separator, fileId, folderName);
            service.createDirectory((Object)projectId, folderPath.split(File.separator));
            ClientProjectFile child = service.getChild((Object)projectId, folderPath.split(File.separator));
            return new CSBaseProjectFile(child);
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private List<ProjectInfo> filter(List<UserProjectInfo> infos) {
        ArrayList<ProjectInfo> projectInfos = new ArrayList<ProjectInfo>();
        infos.stream().filter(CSBaseProjectServiceImpl.isAvailable()).forEach(i -> projectInfos.add(new CSBaseProjectInfo((UserProjectInfo)i)));
        return projectInfos;
    }

    private static Predicate<UserProjectInfo> isAvailable() {
        return new Predicate<UserProjectInfo>(){

            @Override
            public boolean test(UserProjectInfo info) {
                ProjectServiceInterface service = ClientRemoteLocator.projectService;
                try {
                    ProjectAdminInfo projectAdminInfo = service.getProjectAdminInfo(info.getProjectId());
                    return projectAdminInfo == null || !projectAdminInfo.isLocked() && !projectAdminInfo.isWaitingAreaFree();
                }
                catch (RemoteException e) {
                    return false;
                }
            }
        };
    }

    private void setCSBaseSharingType(Object projectId, SharingType type, Set<Object> usersRO, Set<Object> usersRW) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            switch (type) {
                case PRIVATE: {
                    service.updateUsers(projectId, ProjectPermissions.SharingType.PRIVATE, null, null);
                    break;
                }
                case PUBLIC_RO: {
                    service.updateUsers(projectId, ProjectPermissions.SharingType.ALL_RO, null, null);
                    break;
                }
                case PUBLIC_RW: {
                    service.updateUsers(projectId, ProjectPermissions.SharingType.ALL_RW, null, null);
                    break;
                }
                case SELECTIVE: {
                    service.updateUsers(projectId, ProjectPermissions.SharingType.PARTIAL, usersRO, usersRW);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

