/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.user.v1;

import csbase.logic.Role;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import ibase.rest.api.user.v1.adapter.User;
import java.rmi.RemoteException;

public class CSBaseUser
implements User {
    private csbase.logic.User user;

    public CSBaseUser(csbase.logic.User user) {
        this.user = user;
    }

    public String getId() {
        return this.user.getId().toString();
    }

    public String getName() {
        return this.user.getName();
    }

    public String getLogin() {
        return this.user.getLogin();
    }

    public String getEmail() {
        String[] emails = this.user.getEmails();
        return emails != null && emails.length > 0 ? emails[0] : null;
    }

    public String getPhotoLink() {
        return (String)this.user.getAttribute("photoLink");
    }

    public boolean isAdmin() {
        return this.user.isAdmin();
    }

    public boolean isGuest() {
        AdministrationServiceInterface administrationService = ClientRemoteLocator.administrationService;
        try {
            Object[] roleIds;
            for (Object id : roleIds = this.user.getRoleIds()) {
                Role role = administrationService.getRole(id);
                if (!role.getName().equals("VISITOR_ROLE")) continue;
                return true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }
}

