/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.AdministrationEvent;
import csbase.logic.Permission;
import csbase.logic.Platform;
import csbase.logic.Role;
import csbase.logic.User;
import csbase.logic.UserGroup;
import csbase.remote.RemoteEvent;
import csbase.remote.RemoteObserver;
import csbase.remote.TransactionCallbackInterface;
import csbase.server.LocalServerRemoteMonitor;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.administrationservice.LocalAdministrationService;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

class CentralAdministrationObserver
extends UnicastRemoteObject
implements RemoteObserver,
TransactionCallbackInterface {
    LocalAdministrationService service;
    boolean lockMode;

    CentralAdministrationObserver(LocalAdministrationService service) throws RemoteException {
        super(Server.getInstance().getRMIExportPort());
        this.service = service;
        this.lockMode = false;
    }

    void setLockMode(boolean lockMode) {
        this.lockMode = lockMode;
    }

    public boolean isAlive() {
        return this.lockMode;
    }

    public void install() throws RemoteException {
        LocalServerRemoteMonitor.getInstance().addObserver("AdministrationService", this, null);
    }

    public void uninstall() throws RemoteException {
        LocalServerRemoteMonitor.getInstance().deleteObserver("AdministrationService", this, null);
        CentralAdministrationObserver.unexportObject(this, true);
    }

    public void update(RemoteEvent remoteEvent) throws RemoteException {
        try {
            try {
                Service.setUserId(User.getAdminId());
                AdministrationEvent event = (AdministrationEvent)remoteEvent;
                if (event.item instanceof User) {
                    this.service.updateUser(event);
                } else if (event.item instanceof UserGroup) {
                    this.service.updateUserGroup(event);
                } else if (event.item instanceof Role) {
                    this.service.updateRole(event);
                } else if (event.item instanceof Permission) {
                    this.service.updatePermission(event);
                } else if (event.item instanceof Platform) {
                    this.service.updatePlatform(event);
                } else {
                    Server.logSevereMessage("Evento n\u00e3o reconhecido: " + event + " - item=" + event.item);
                }
            }
            catch (Exception e) {
                String msg = "Falha na atualiza\u00e7\u00e3o de usu\u00e1rio em servidor local.";
                Server.logSevereMessage(msg, e);
                throw new RemoteException(msg, e);
            }
        }
        finally {
            Service.setUserId(null);
        }
    }

    public void update(RemoteEvent[] events) throws RemoteException {
        int i = 0;
        while (i < events.length) {
            this.update(events[i]);
            ++i;
        }
    }
}

