/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors.openbus;

import csbase.exception.OperationFailureException;
import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csbase.server.services.openbusservice.OpenBusService;
import java.util.Locale;
import java.util.Properties;
import scs.core.ComponentId;
import scs.core.IComponent;

public class DuplicatedOfferValidation
implements Validation {
    public static final String NAME = "DuplicatedOfferValidation";
    private ComponentId component;

    public DuplicatedOfferValidation(ComponentId component) {
        this.component = component;
    }

    @Override
    public ValidationStatus check(Locale locale) {
        IComponent[] services;
        String[] facets = OpenBusService.getInstance().getRegisteredComponentFacets(this.component);
        Properties properties = OpenBusService.getInstance().getRegisteredComponentProperties(this.component);
        String entity = OpenBusService.getInstance().getEntityName();
        properties.put("openbus.offer.entity", entity);
        String[] stringArray = facets;
        int n = facets.length;
        int n2 = 0;
        while (n2 < n) {
            String facet = stringArray[n2];
            properties.put("openbus.component.interface", facet);
            ++n2;
        }
        try {
            services = OpenBusService.getInstance().findServiceList(properties);
        }
        catch (OperationFailureException e) {
            return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.offermonitor.no.one.error", new String[]{properties.toString()}, locale));
        }
        int num = services.length;
        if (num == 1) {
            return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.offermonitor.just.one.success", new String[]{properties.toString()}, locale));
        }
        if (num >= 1) {
            return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.offermonitor.more.than.one.error", new String[]{String.valueOf(num), properties.toString()}, locale));
        }
        return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.offermonitor.no.one.error", new String[]{properties.toString()}, locale));
    }

    @Override
    public String id() {
        return NAME;
    }

    @Override
    public String[] requires() {
        return new String[]{"RegistryServiceValidation"};
    }
}

