/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.messageservice;

import csbase.logic.User;
import csbase.logic.UserOutline;
import csbase.remote.IRemoteMessageListener;
import csbase.remote.MessageServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.loginservice.LoginServiceListener;
import csbase.server.services.loginservice.ServerSession;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.MessageBroker;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import tecgraf.javautils.core.filter.IFilter;

public class MessageService
extends Service
implements MessageServiceInterface,
LoginServiceListener {
    private static final String CONSUMER_ID_SESSION_PROPERTY = "MessageService.consumer_id";
    private MessageBroker broker;
    private String serverTopicName = "SERVER_TOPIC";

    public static MessageService getInstance() {
        return (MessageService)MessageService.getInstance("MessageService");
    }

    public static void createService() throws ServerException {
        new MessageService();
    }

    public MessageService() throws ServerException {
        super("MessageService");
    }

    public void broadcast(Message message, long timeToLive) throws RemoteException {
        if (!this.isActive()) {
            return;
        }
        String senderName = MessageService.getUser().getLogin();
        try {
            List users = User.getAllUsers();
            String[] logins = new String[users.size() - 1];
            int inx = 0;
            while (inx < users.size()) {
                String aLogin = ((User)users.get(inx)).getLogin();
                if (!aLogin.equals(senderName)) {
                    logins[inx] = aLogin;
                }
                ++inx;
            }
            this.broker.send(message, timeToLive, logins);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de notifica\u00e7\u00e3o all-users.", e);
        }
    }

    public void send(Message message, long timeToLive, String ... usersLogins) throws RemoteException {
        if (!this.isActive()) {
            return;
        }
        this.broker.send(message, timeToLive, usersLogins);
    }

    public Message[] receive(IFilter<Message> filter) throws RemoteException {
        if (!this.isActive()) {
            return new Message[0];
        }
        String topicName = MessageService.getUser().getLogin();
        Serializable consumerId = this.getConsumerId();
        return this.broker.receive(topicName, consumerId, filter);
    }

    public void clearMessageListener() throws RemoteException {
        if (!this.isActive()) {
            return;
        }
        String topicName = MessageService.getUser().getLogin();
        Serializable consumerId = this.getConsumerId();
        this.broker.removeMessageListener(topicName, consumerId);
    }

    public void setMessageListener(IRemoteMessageListener listener, IFilter<Message> filter) throws RemoteException {
        if (!this.isActive()) {
            return;
        }
        String topicName = MessageService.getUser().getLogin();
        Serializable consumerId = this.getConsumerId();
        this.broker.setMessageListener(topicName, consumerId, (IMessageListener)listener, filter);
    }

    @Override
    public void systemNameSet(String login, Object sessionKey, String systemName, long time) {
    }

    @Override
    public void sessionCreated(String login, Object sessionKey, long time) {
    }

    @Override
    public void connectionLost(String login, Object sessionKey, String systemName, long time) {
    }

    @Override
    public void userLoggingOut(String login, Object sessionKey, String systemName, long time) {
        LoginService loginService = LoginService.getInstance();
        Serializable consumerId = (Serializable)loginService.getSessionProperty(sessionKey, CONSUMER_ID_SESSION_PROPERTY);
        if (consumerId != null) {
            this.broker.removeMessageListener(login, consumerId);
        }
    }

    @Override
    protected void initService() throws ServerException {
        LoginService.getInstance().addListener(this);
        this.broker = Server.getInstance().getMessageBroker();
        this.broker.start();
    }

    @Override
    protected void shutdownService() throws ServerException {
        LoginService.getInstance().removeListener(this);
        this.broker.stop();
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    public void send(Message message, String ... usersLogins) throws RemoteException {
        this.send(message, 0L, usersLogins);
    }

    public void sendToAll(Message message) {
        try {
            UserOutline[] users = LoginService.getInstance().getLoggedUsers();
            String[] logins = new String[users.length];
            int i = 0;
            while (i < users.length) {
                logins[i] = users[i].getLogin();
                ++i;
            }
            this.send(message, logins);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de notifica\u00e7\u00e3o sendToAll.", e);
        }
    }

    public void sendToAdmin(Message message, long timeToLive) throws RemoteException {
        Vector ids = new Vector();
        try {
            ids.addAll(User.getAdminIds());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
        }
        this.send(message, timeToLive, ids.toArray(new String[0]));
    }

    public void sendToAdmin(Message message) throws RemoteException {
        this.sendToAdmin(message, 0L);
    }

    public void sendToServer(Message message) {
        try {
            this.send(message, 0L, this.serverTopicName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void clearServerMessageListener(Serializable consumerId) {
        if (consumerId == null) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        this.broker.removeMessageListener(this.serverTopicName, consumerId);
    }

    public Serializable setServerMessageListener(IMessageListener listener, IFilter<Message> filter) {
        if (!this.isActive()) {
            return null;
        }
        Serializable consumerId = this.broker.createConsumerId();
        this.broker.setMessageListener(this.serverTopicName, consumerId, listener, filter);
        return consumerId;
    }

    public void clearMessageListener(ServerSession session) {
        if (!this.isActive()) {
            return;
        }
        String topicName = session.getUser().getLogin();
        Serializable consumerId = this.getConsumerId(session);
        if (consumerId != null) {
            this.broker.removeMessageListener(topicName, consumerId);
        }
    }

    private synchronized Serializable getConsumerId() {
        LoginService loginService = LoginService.getInstance();
        Serializable consumerId = (Serializable)loginService.getSessionProperty(MessageService.getKey(), CONSUMER_ID_SESSION_PROPERTY);
        if (consumerId == null) {
            consumerId = this.broker.createConsumerId();
            loginService.setSessionProperty(MessageService.getKey(), CONSUMER_ID_SESSION_PROPERTY, consumerId);
        }
        return consumerId;
    }

    private Serializable getConsumerId(ServerSession session) {
        return (Serializable)session.getProperty(CONSUMER_ID_SESSION_PROPERTY);
    }
}

