/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.exception.ServiceFailureException;
import csbase.logic.FileUpdateNotification;
import csbase.logic.Notification;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.loginservice.LoginServiceListener;
import csbase.server.services.notificationservice.NotificationService;
import csbase.server.services.projectservice.FileUpdateInfo;
import csbase.server.services.projectservice.ProjectFileUpdater;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.projectservice.ServerProjectFile;
import csbase.server.services.projectservice.UpdatableFileInfo;
import csbase.server.services.projectservice.UpdatableFileLocation;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

final class ProjectFileUpdateScheduler {
    private Map<Class<? extends ProjectFileUpdater>, ProjectFileUpdater> updaters = new HashMap<Class<? extends ProjectFileUpdater>, ProjectFileUpdater>();
    private Timer scheduler;
    private Map<UpdatableFileLocation, TimerTask> tasks;
    private Map<UpdatableFileLocation, FileUpdateInfo> updates;
    private LoginServiceListenerImpl loginServiceListener;

    ProjectFileUpdateScheduler(List<String> updaters) {
        for (String updaterClassName : updaters) {
            try {
                Class<?> updaterClass = Class.forName(updaterClassName);
                try {
                    this.updaters.put(updaterClass, (ProjectFileUpdater)updaterClass.newInstance());
                }
                catch (InstantiationException e) {
                    Server.logSevereMessage(String.format("Falha ao instanciar o atualizador de arquivos da classe {0}", updaterClassName), e);
                }
                catch (IllegalAccessException e) {
                    Server.logSevereMessage(String.format("Falha ao instanciar o atualizador de arquivos da classe {0}", updaterClassName), e);
                }
            }
            catch (ClassNotFoundException e) {
                Server.logSevereMessage(String.format("N\u00e3o foi poss\u00edvel carregar o atualizador de arquivos da classe {0}", updaterClassName), e);
            }
        }
        this.scheduler = new Timer(true);
        this.tasks = new HashMap<UpdatableFileLocation, TimerTask>();
        this.updates = new HashMap<UpdatableFileLocation, FileUpdateInfo>();
        this.loginServiceListener = new LoginServiceListenerImpl();
    }

    public void init() {
        LoginService.getInstance().addListener(this.loginServiceListener);
    }

    public void shutdown() {
        LoginService.getInstance().removeListener(this.loginServiceListener);
        this.scheduler.cancel();
    }

    public UpdatableFileLocation getFileLocation(ServerProjectFile spf) {
        return new UpdatableFileLocation(spf.getProjectId(), spf.getPath());
    }

    public FileUpdateInfo getFileUpdateInfo(UpdatableFileLocation fileLocation) {
        return this.updates.get(fileLocation);
    }

    void singleUpdate(ServerProjectFile spf) {
        this.startUpdate(spf, -1L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startUpdate(ServerProjectFile spf, long interval, boolean notification) {
        TimerTask task;
        Class<? extends ProjectFileUpdater> updaterClass;
        UpdatableFileInfo info = spf.getUpdatableFileInfo();
        try {
            updaterClass = info.getServiceClass();
            if (this.updaters.get(updaterClass) == null) {
                Server.logSevereMessage(MessageFormat.format("A atualiza\u00e7\u00e3o do arquivo {0} n\u00e3o pode ser agendada pois a classe do atualizador, {1}, n\u00e3o est\u00e1 definida na propriedade ProjectService.updater.class.", spf.getName(), updaterClass.getName()));
                return;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ServiceFailureException("A classe de um atualizador de arquivo n\u00e3o foi encontrada.", (Throwable)e);
        }
        UpdatableFileLocation fileLocation = new UpdatableFileLocation(spf.getProjectId(), spf.getPath());
        Map<UpdatableFileLocation, TimerTask> map = this.tasks;
        synchronized (map) {
            task = this.tasks.get(fileLocation);
            if (task != null) {
                task.cancel();
                this.scheduler.purge();
            }
            task = new UpdaterTimerTask(spf.getProjectId(), fileLocation, this.updaters.get(updaterClass), info, notification);
            this.tasks.put(fileLocation, task);
            this.updates.put(fileLocation, new FileUpdateInfo(Service.getUser().getLogin(), interval));
            this.loginServiceListener.addFileLocation(fileLocation);
        }
        if (interval > 0L) {
            this.scheduler.schedule(task, interval * 1000L, interval * 1000L);
        } else {
            this.scheduler.schedule(task, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopUpdate(ServerProjectFile spf) {
        Map<UpdatableFileLocation, TimerTask> map = this.tasks;
        synchronized (map) {
            this.stopUpdate(new UpdatableFileLocation(spf.getProjectId(), spf.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopUpdate(UpdatableFileLocation path) {
        Map<UpdatableFileLocation, TimerTask> map = this.tasks;
        synchronized (map) {
            this.loginServiceListener.removeFileLocation(path);
            this.updates.remove(path);
            TimerTask task = this.tasks.remove(path);
            if (task == null) {
                return;
            }
            task.cancel();
            this.scheduler.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopUpdate(Set<UpdatableFileLocation> fileLocationSet) {
        Map<UpdatableFileLocation, TimerTask> map = this.tasks;
        synchronized (map) {
            for (UpdatableFileLocation filePath : fileLocationSet) {
                this.stopUpdate(filePath);
            }
        }
    }

    private class LoginServiceListenerImpl
    implements LoginServiceListener {
        private Map<Object, Set<UpdatableFileLocation>> usersToFileLocationSet = new HashMap<Object, Set<UpdatableFileLocation>>();
        private Map<UpdatableFileLocation, Object> fileLocationToUser = new HashMap<UpdatableFileLocation, Object>();

        LoginServiceListenerImpl() {
        }

        void addFileLocation(UpdatableFileLocation fileLocation) {
            Object sessionKey = Service.getKey();
            if (sessionKey == null) {
                return;
            }
            Set<UpdatableFileLocation> fileLocationSet = this.usersToFileLocationSet.get(sessionKey);
            if (fileLocationSet == null) {
                fileLocationSet = new HashSet<UpdatableFileLocation>();
            }
            fileLocationSet.add(fileLocation);
            this.usersToFileLocationSet.put(sessionKey, fileLocationSet);
            this.fileLocationToUser.put(fileLocation, sessionKey);
        }

        void removeFileLocation(UpdatableFileLocation fileLocation) {
            Object sessionKey = this.fileLocationToUser.remove(fileLocation);
            if (sessionKey == null) {
                return;
            }
            Set<UpdatableFileLocation> fileLocationSet = this.usersToFileLocationSet.get(sessionKey);
            fileLocationSet.remove(fileLocation);
            if (fileLocationSet.size() == 0) {
                this.usersToFileLocationSet.remove(sessionKey);
            }
        }

        @Override
        public void userLoggingOut(String login, Object sessionKey, String systemName, long time) {
            Set<UpdatableFileLocation> fileLocationSet = this.usersToFileLocationSet.get(sessionKey);
            if (fileLocationSet != null) {
                ProjectFileUpdateScheduler.this.stopUpdate(new HashSet<UpdatableFileLocation>(fileLocationSet));
            }
        }

        @Override
        public void systemNameSet(String login, Object sessionKey, String systemName, long time) {
        }

        @Override
        public void sessionCreated(String login, Object sessionKey, long time) {
        }

        @Override
        public void connectionLost(String login, Object sessionKey, String systemName, long time) {
        }
    }

    private class UpdaterTimerTask
    extends TimerTask {
        private Object key = Service.getKey();
        private String userLogin = Service.getUser().getLogin();
        private Object projectId;
        private UpdatableFileLocation fileLocation;
        private ProjectFileUpdater updater;
        private UpdatableFileInfo fileInfo;
        private String fileLocationPath;
        private boolean notification;

        UpdaterTimerTask(Object projectId, UpdatableFileLocation fileLocation, ProjectFileUpdater updater, UpdatableFileInfo fileInfo, boolean notification) {
            this.projectId = projectId;
            this.fileLocation = fileLocation;
            this.updater = updater;
            this.fileInfo = fileInfo;
            this.notification = notification;
            StringBuilder filePathBuilder = new StringBuilder();
            String[] filePath = this.fileLocation.getPath();
            filePathBuilder.append(filePath[0]);
            int i = 1;
            while (i < filePath.length) {
                filePathBuilder.append("/");
                filePathBuilder.append(filePath[i]);
                ++i;
            }
            this.fileLocationPath = filePathBuilder.toString();
        }

        @Override
        public void run() {
            try {
                Service.setKey(this.key);
                if (ProjectService.getInstance().existsFile(this.projectId, this.fileLocation.getPath())) {
                    FileUpdateNotification.Result result = this.updater.update(this.fileLocation, this.fileInfo.getUserData(), this.fileInfo.getExtraUserData());
                    if (this.notification) {
                        Object[] ids = new Object[]{this.userLogin};
                        NotificationService.getInstance().notifyTo(ids, (Notification)new FileUpdateNotification(ProjectService.getInstance().getSenderName(), this.fileLocationPath, result));
                    }
                } else {
                    this.cancel();
                }
            }
            finally {
                Service.setKey(null);
            }
        }
    }
}

