/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_00;

import csbase.exception.OperationFailureException;
import csbase.server.services.openbusservice.OpenBusService;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import scs.core.ComponentId;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.openbus.data_service.DataKey;
import tecgraf.openbus.data_service.IHierarchicalDataService;
import tecgraf.openbus.data_service.IHierarchicalDataServiceHelper;
import tecgraf.openbus.data_service.IHierarchicalNavigationDataService;
import tecgraf.openbus.data_service.IHierarchicalNavigationDataServiceHelper;
import tecgraf.openbus.data_service.ServiceFailure;

public class FindService {
    private static final String INTERFACE_PROPERTY_NAME = "openbus.component.interface";
    private static final String COMPONENT_NAME_PROPERTY_NAME = "openbus.component.name";
    private static final String COMPONENT_MAJOR_VERSION_PROPERTY_NAME = "openbus.component.version.major";
    private static final String COMPONENT_VERSION_MINOR_PROPERTY_NAME = "openbus.component.version.minor";
    private static final String COMPONENT_VERSION_PATCH_PROPERTY_NAME = "openbus.component.version.patch";

    protected static IHierarchicalNavigationDataService find(DataKey dataKey) throws ServiceFailure {
        Object obj;
        IHierarchicalDataService dataService;
        String serviceFacetIOR = dataKey.getServiceFacetIOR();
        IComponent component = null;
        if (serviceFacetIOR != null) {
            ORB orb = OpenBusService.getInstance().getORB();
            Object obj2 = orb.string_to_object(serviceFacetIOR);
            component = IComponentHelper.narrow((Object)obj2);
            if (component == null) {
                return null;
            }
            if (!FindService.isReachable(component)) {
                return null;
            }
        } else {
            ComponentId componentId = dataKey.getServiceComponentId();
            if (componentId == null) {
                return null;
            }
            Properties properties = new Properties();
            properties.setProperty(COMPONENT_NAME_PROPERTY_NAME, componentId.name);
            properties.setProperty(COMPONENT_MAJOR_VERSION_PROPERTY_NAME, Byte.toString(componentId.major_version));
            properties.setProperty(COMPONENT_VERSION_MINOR_PROPERTY_NAME, Byte.toString(componentId.minor_version));
            properties.setProperty(COMPONENT_VERSION_PATCH_PROPERTY_NAME, Byte.toString(componentId.patch_version));
            properties.setProperty(INTERFACE_PROPERTY_NAME, dataKey.getServiceFacetName());
            try {
                component = OpenBusService.getInstance().findService(properties);
                if (component == null) {
                    return null;
                }
            }
            catch (OperationFailureException e) {
                throw new ServiceFailure("Erro ao buscar o servi\u00e7o de dados.");
            }
        }
        if ((dataService = IHierarchicalDataServiceHelper.narrow((Object)(obj = component.getFacet(IHierarchicalDataServiceHelper.id())))) == null) {
            obj = component.getFacet(IHierarchicalNavigationDataServiceHelper.id());
            dataService = IHierarchicalNavigationDataServiceHelper.narrow((Object)obj);
        }
        return dataService;
    }

    private static boolean isReachable(IComponent component) {
        block3: {
            try {
                if (!component._non_existent()) break block3;
                return false;
            }
            catch (SystemException e) {
                return false;
            }
        }
        component.getComponentId();
        return true;
    }
}

