/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice;

import csbase.logic.CommandInfo;
import csbase.server.Service;
import csbase.server.services.sgaservice.SGAService;
import org.omg.CORBA.IntHolder;
import sgaidl.CompletedCommandInfo;
import sgaidl.RetrievedInfo;
import sgaidl.SGACommand;
import sgaidl.SGADynamicInfo;
import sgaidl.SGAManagerPOA;
import sgaidl.SGAServer;
import sgaidl.StaticNodeInfo;

public class SGAHandler
extends SGAManagerPOA {
    private SGAService service = null;

    public boolean registerSGA(SGAServer sga, String sganame, StaticNodeInfo[] staticNodesInfo, IntHolder updateInterval) {
        return this.service.registerSGA(sga, sganame, staticNodesInfo, updateInterval);
    }

    public void unregisterSGA(SGAServer sga, String sganame) {
        this.service.unregisterSGA(sga, sganame);
    }

    public void setSGAEnabled(SGAServer sga, String sganame) {
        this.service.setSGAEnabled(sganame);
    }

    public void setSGADisabled(SGAServer sga, String sganame) {
        this.service.setSGADisabled(sganame);
    }

    public boolean commandCompleted(String sgaName, SGACommand cmd, String cmdId, CompletedCommandInfo info, String cmdString) {
        try {
            CommandInfo command = this.service.getSGACommand(sgaName, cmdId);
            if (command != null) {
                Object userId = command.getUserId();
                Service.setUserId(userId);
            }
            boolean bl = this.service.commandCompleted(sgaName, cmd, cmdId, info);
            return bl;
        }
        finally {
            Service.setUserId(null);
        }
    }

    public boolean commandLost(String sgaName, String cmdId, String cmdString) {
        try {
            CommandInfo command = this.service.getSGACommand(sgaName, cmdId);
            if (command != null) {
                Object userId = command.getUserId();
                Service.setUserId(userId);
            }
            boolean bl = this.service.commandLost(sgaName, cmdId);
            return bl;
        }
        finally {
            Service.setUserId(null);
        }
    }

    public boolean commandRetrieved(String sgaName, RetrievedInfo[] cmds) {
        return this.service.commandRetrieved(sgaName, cmds);
    }

    public boolean isRegistered(SGAServer sga, String sganame) {
        return this.service.isRegistered(sga, sganame);
    }

    public boolean updateSGAInfo(SGAServer sga, String sganame, SGADynamicInfo dynamicInfo) {
        return this.service.updateSGAInfo(sga, sganame, dynamicInfo);
    }

    public SGAHandler(SGAService srv) {
        this.service = srv;
    }
}

