/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.wioservice;

import csbase.server.Server;
import csbase.server.services.wioservice.idl.WIOServiceException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.Servant;

public class ORBDealer
extends Thread {
    private ORB orb = null;
    private POA rootPOA = null;
    private POA persistentIdPOA = null;
    private POA persistentAnonPOA = null;
    private final Hashtable<String, String> hashIds = new Hashtable();
    private boolean isActive;

    public POA activateObject(String oid, Servant object) throws WIOServiceException {
        if (!this.isActive) {
            String err = "CORBA desativado na ativacao de objeto";
            WIOServiceException exception = new WIOServiceException("CORBA desativado na ativacao de objeto");
            Server.logSevereMessage("CORBA desativado na ativacao de objeto");
            throw exception;
        }
        POA myPOA = null;
        try {
            if (oid == null) {
                myPOA = this.persistentAnonPOA;
                myPOA.activate_object(object);
            } else {
                myPOA = this.persistentIdPOA;
                if (this.hashIds.get(oid) == null) {
                    myPOA.activate_object_with_id(oid.getBytes(), object);
                    this.hashIds.put(oid, oid);
                    Object o = myPOA.servant_to_reference(object);
                    String ior = this.orb.object_to_string(o);
                    Server.logFineMessage("Ativa\u00e7\u00e3o: Object IOR [" + ior + "]");
                }
            }
            return myPOA;
        }
        catch (ObjectAlreadyActive e) {
            String err = String.valueOf(e.getMessage()) + "\n" + "ORB dealer: Dupla ativa\u00e7\u00e3o de objeto CORBA " + "[" + object.toString() + "] - Object ID: [" + oid + "]";
            Server.logSevereMessage(err);
            return myPOA;
        }
        catch (Exception e) {
            String err = "ORB dealer: Falha na ativacao de CORBA [" + object.toString() + "] - Object ID: [" + oid + "] ->> " + e.getMessage();
            WIOServiceException exception = new WIOServiceException(err);
            Server.logSevereMessage(err);
            e.printStackTrace();
            throw exception;
        }
    }

    public void deactivateObject(Servant object) throws WIOServiceException {
        if (!this.isActive) {
            String err = "CORBA desativado para desativacao de objeto";
            WIOServiceException exception = new WIOServiceException("CORBA desativado para desativacao de objeto");
            Server.logSevereMessage("CORBA desativado para desativacao de objeto");
            throw exception;
        }
        try {
            POA poa = object._poa();
            poa.deactivate_object(object._object_id());
        }
        catch (Exception e) {
            String err = e.getMessage();
            WIOServiceException exception = new WIOServiceException(err);
            Server.logSevereMessage(err);
            e.printStackTrace();
            throw exception;
        }
    }

    private void init(Properties props) throws Exception {
        props.setProperty("jacorb.connection.client.disconnect_after_systemexception", "false");
        Set<java.lang.Object> keySet = props.keySet();
        for (java.lang.Object key : keySet) {
            String value = props.getProperty((String)key);
            Server.logInfoMessage("Propriedade ORB: " + key + " = " + value);
        }
        try {
            String[] args = null;
            this.orb = ORB.init(args, (Properties)props);
            String serverName = "WIOMgr";
            this.rootPOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
            Policy[] idPolicies = new Policy[]{this.rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
            this.persistentIdPOA = this.rootPOA.create_POA("WIOMgrPOA", this.rootPOA.the_POAManager(), idPolicies);
            Policy[] id2Policies = new Policy[]{this.rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
            this.persistentAnonPOA = this.rootPOA.create_POA("WIOMgrAnonPOA", this.rootPOA.the_POAManager(), id2Policies);
            Policy[] policyArray = idPolicies;
            int n = idPolicies.length;
            int n2 = 0;
            while (n2 < n) {
                Policy idPolicie = policyArray[n2];
                idPolicie.destroy();
                ++n2;
            }
            policyArray = id2Policies;
            n = id2Policies.length;
            n2 = 0;
            while (n2 < n) {
                Policy id2Policie = policyArray[n2];
                id2Policie.destroy();
                ++n2;
            }
            this.rootPOA.the_POAManager().activate();
            this.persistentIdPOA.the_POAManager().activate();
            this.persistentAnonPOA.the_POAManager().activate();
            this.start();
        }
        catch (UserException e) {
            throw new Exception("Erro na inicializa\u00e7\u00e3o de servidor CORBA", e);
        }
    }

    @Override
    public void run() {
        Server.logFineMessage("Thread iniciada: ORBDealer");
        this.orb.run();
        this.orb.destroy();
        Server.logFineMessage("Thread terminada: ORBDealer");
    }

    public void shutdown() throws Exception {
        if (!this.isActive) {
            throw new Exception("Servidor CORBA desativado");
        }
        this.orb.shutdown(false);
        this.isActive = false;
    }

    public ORBDealer(Properties props) throws Exception {
        this.init(props);
        this.isActive = true;
    }
}

