/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.wioservice;

import csbase.logic.User;
import csbase.server.Server;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.wioservice.WIOServerFile;
import csbase.server.services.wioservice.WIOServerFileSystem;
import csbase.server.services.wioservice.WIOService;
import csbase.server.services.wioservice.idl.FileInfo;
import csbase.server.services.wioservice.idl.WIOFile;
import csbase.server.services.wioservice.idl.WIOFileHelper;
import csbase.server.services.wioservice.idl.WIOProjectPOA;
import csbase.server.services.wioservice.idl.WIOServiceException;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import tecgraf.javautils.core.io.FileUtils;

public class WIOServerProject
extends WIOProjectPOA {
    private String projectName = null;
    private int numFiles = 0;
    private WIOServerFileSystem fileSystem = null;
    private final String userLogin;
    private final String ownerLogin;

    protected POA activateCorbaProject() throws Exception {
        WIOService wioService = this.getWIOService();
        return wioService.activateCorbaObject(null, (Servant)this);
    }

    protected void appendDescription(String path, String description) throws Exception {
        String[] srvPath = this.mountServerPath(path);
        this.checkExists(srvPath);
        String text = description == null ? "<null>" : description;
        ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
        java.lang.Object pid = this.getMyProjectId();
        projectService.appendFileDescription(pid, srvPath, text);
        ProjectService.setUserId(null);
    }

    private void checkExists(String[] srvPath) throws Exception {
        if (srvPath == null) {
            String err = "Path array nulo em projeto " + this.toString();
            throw new Exception(err);
        }
        ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
        java.lang.Object pid = this.getMyProjectId();
        boolean exists = projectService.existsFile(pid, srvPath);
        ProjectService.setUserId(null);
        if (!exists) {
            String path = FileUtils.joinPath((String[])srvPath);
            String err = "[" + path + "] inexistente no projeto " + this.toString();
            throw new Exception(err);
        }
    }

    private void checkNotExists(String[] srvPath) throws Exception {
        if (srvPath == null) {
            String err = "Path array nulo em projeto " + this.toString();
            throw new Exception(err);
        }
        ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
        java.lang.Object pid = this.getMyProjectId();
        boolean exists = projectService.existsFile(pid, srvPath);
        ProjectService.setUserId(null);
        if (exists) {
            String path = FileUtils.joinPath((String[])srvPath);
            String err = "[" + path + "] j\u00e1 existente no projeto " + this.toString();
            throw new Exception(err);
        }
    }

    private void checkServerProject() throws Exception {
        java.lang.Object uid;
        java.lang.Object pid;
        ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
        boolean projectInexistant = !projectService.existsProject(pid = projectService.getProjectId(uid = User.getUserByLogin((String)this.userLogin).getId(), this.projectName));
        ProjectService.setUserId(null);
        if (projectInexistant) {
            String fmt = "Projeto nulo detectado: %s (usuario %s)";
            String err = String.format("Projeto nulo detectado: %s (usuario %s)", this.projectName, this.userLogin);
            throw new Exception(err);
        }
    }

    public void copyFile(String fromPath, String toPath) throws WIOServiceException {
        try {
            try {
                ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
                String[] fromSrvPath = this.mountServerPath(fromPath);
                String[] toSrvPath = this.mountServerPath(toPath);
                this.checkExists(fromSrvPath);
                java.lang.Object pid = this.getMyProjectId();
                projectService.copyFile(pid, fromSrvPath, toSrvPath);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha de copyFile", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        finally {
            ProjectService.setUserId(null);
        }
    }

    public WIOFile createDirectory(String path) throws WIOServiceException {
        String err;
        try {
            try {
                ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
                String[] srvPath = this.mountServerPath(path);
                this.checkNotExists(srvPath);
                java.lang.Object pid = this.getMyProjectId();
                projectService.createDirectory(pid, srvPath);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha de createDirectory", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        finally {
            ProjectService.setUserId(null);
        }
        WIOFile file = this.getFile(path);
        if (file == null) {
            err = "Diretorio [" + path + "] nao apareceu no projeto ";
            throw new WIOServiceException(err);
        }
        if (!file.isDirectory()) {
            err = "[" + path + "] nao apareceu no projeto como diretorio";
            throw new WIOServiceException(err);
        }
        return file;
    }

    public WIOFile createFile(String path, String type, String userId) throws WIOServiceException {
        try {
            ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
            String[] srvPath = this.mountServerPath(path);
            java.lang.Object pid = this.getMyProjectId();
            if (!projectService.existsFile(pid, srvPath)) {
                String[] dirPath = new String[srvPath.length - 1];
                int i = 0;
                while (i < srvPath.length - 1) {
                    dirPath[i] = srvPath[i];
                    ++i;
                }
                String fileName = srvPath[srvPath.length - 1];
                projectService.createFile(pid, dirPath, fileName, type);
            }
            WIOFile wIOFile = this.getFile(path);
            return wIOFile;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de createFile", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
        finally {
            ProjectService.setUserId(null);
        }
    }

    protected void deactivateCorbaProject() throws Exception {
        WIOService wioService = this.getWIOService();
        wioService.deactivateCorbaObject((Servant)this);
    }

    protected void decNumFiles() throws Exception {
        if (this.numFiles <= 0) {
            String err = "Underflow em numero de arquivos abertos no projeto.";
            Server.logSevereMessage("Underflow em numero de arquivos abertos no projeto.");
            throw new Exception("Underflow em numero de arquivos abertos no projeto.");
        }
        --this.numFiles;
        this.fileSystem.decNumFiles();
    }

    public void deleteFile(String path) throws WIOServiceException {
        try {
            try {
                String[] srvPath = this.mountServerPath(path);
                this.checkExists(srvPath);
                ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
                java.lang.Object pid = this.getMyProjectId();
                projectService.removeFile(pid, srvPath);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha de deleteFile", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        finally {
            ProjectService.setUserId(null);
        }
    }

    public void destroy() throws WIOServiceException {
        try {
            this.deactivateCorbaProject();
            this.fileSystem.decNumProjects();
            this.fileSystem.incNumProjects();
            String fmt = "Projeto '%s' do usu\u00e1rio %s fechado pelo usu\u00e1rio %s.";
            String msg = String.format("Projeto '%s' do usu\u00e1rio %s fechado pelo usu\u00e1rio %s.", this.projectName, this.ownerLogin, this.userLogin);
            Server.logInfoMessage(msg);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de destroy", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public boolean fileExists(String path) throws WIOServiceException {
        try {
            ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
            String[] srvPath = this.mountServerPath(path);
            java.lang.Object pid = this.getMyProjectId();
            boolean bl = projectService.existsFile(pid, srvPath);
            return bl;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de fileExists", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
        finally {
            ProjectService.setUserId(null);
        }
    }

    protected String getDescription(String path) throws Exception {
        String[] srvPath = this.mountServerPath(path);
        this.checkExists(srvPath);
        ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
        java.lang.Object pid = this.getMyProjectId();
        String desc = projectService.getFileDescription(pid, srvPath);
        ProjectService.setUserId(null);
        desc = desc == null || desc.trim().equals("") ? "" : desc;
        return desc;
    }

    public WIOFile getFile(String path) throws WIOServiceException {
        try {
            this.checkServerProject();
            WIOServerFile file = new WIOServerFile(this, path);
            POA poa = file.activateCorbaFile();
            WIOFile corbaFile = WIOFileHelper.narrow((Object)poa.servant_to_reference((Servant)file));
            if (corbaFile == null) {
                String err = "Arquivo nulo detectado (path: " + path + ")";
                throw new Exception(err);
            }
            return corbaFile;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de getFile", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public FileInfo[] getFilesInfo(String path, boolean recur) throws WIOServiceException {
        try {
            String err = "Falha nos paths em getFilesInfo() " + this.toString();
            throw new Exception(err);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de getFilesInfo", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public String getId() throws WIOServiceException {
        try {
            this.checkServerProject();
            return this.projectName;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de getId", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    String getLoggedUserLogin() {
        return this.userLogin;
    }

    public int getMaxOpenedFiles() throws WIOServiceException {
        try {
            WIOService wioService = this.getWIOService();
            int MAX_NUM_FILES = wioService.getMaxOpenedFiles();
            return MAX_NUM_FILES;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de getMaxOpenedFiles", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    private java.lang.Object getMyProjectId() {
        User oldUser = ProjectService.getUser();
        ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
        ProjectService.setUserId(User.getAdminId());
        java.lang.Object userId = this.getMyUserId();
        java.lang.Object pid = projectService.getProjectId(userId, this.projectName);
        if (oldUser != null) {
            ProjectService.setUserId(oldUser.getId());
        }
        return pid;
    }

    private java.lang.Object getMyUserId() {
        User loggedUser = null;
        try {
            loggedUser = User.getUserByLogin((String)this.userLogin);
        }
        catch (Exception e) {
            String fmt = "Falha na obtencao de usuario: %s";
            String err = String.format("Falha na obtencao de usuario: %s", this.userLogin);
            Server.logSevereMessage(err);
            loggedUser = null;
        }
        if (loggedUser == null) {
            String fmt = "Acesso a getProjectService com usuario invalido: %s";
            String err = String.format("Acesso a getProjectService com usuario invalido: %s", this.userLogin);
            Server.logSevereMessage(err);
            return null;
        }
        java.lang.Object luid = loggedUser.getId();
        return luid;
    }

    public int getNumOpenedFiles() throws WIOServiceException {
        try {
            if (this.numFiles < 0) {
                String err = "Valor negativo detectado.";
                throw new Exception("Valor negativo detectado.");
            }
            return this.numFiles;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de getNumOpenedFiles", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    String getProjectName() {
        return this.projectName;
    }

    private ProjectService getProjectServiceWithThreadUserAdjusted() {
        ProjectService prjService = ProjectService.getInstance();
        User loggedUser = null;
        try {
            loggedUser = User.getUserByLogin((String)this.userLogin);
        }
        catch (Exception e) {
            String fmt = "Falha na obtencao de usuario: %s";
            String err = String.format("Falha na obtencao de usuario: %s", this.userLogin);
            Server.logSevereMessage(err);
            loggedUser = null;
        }
        if (loggedUser == null) {
            String fmt = "Acesso a getProjectService com usuario invalido: %s";
            String err = String.format("Acesso a getProjectService com usuario invalido: %s", this.userLogin);
            Server.logSevereMessage(err);
            return prjService;
        }
        java.lang.Object uid = loggedUser.getId();
        ProjectService.setUserId(uid);
        return prjService;
    }

    public WIOFile getRootFile() throws WIOServiceException {
        WIOFile corbaFile = null;
        try {
            this.checkServerProject();
            WIOServerFile root = new WIOServerFile(this, ".");
            POA poa = root.activateCorbaFile();
            corbaFile = WIOFileHelper.narrow((Object)poa.servant_to_reference((Servant)root));
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de getRootFile", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
        if (corbaFile == null) {
            String err = "Falha de diretorio nulo raiz";
            throw new WIOServiceException("Falha de diretorio nulo raiz");
        }
        return corbaFile;
    }

    public String getUser() throws WIOServiceException {
        try {
            this.checkServerProject();
            String string = this.ownerLogin;
            return string;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de getUser", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
        finally {
            ProjectService.setUserId(null);
        }
    }

    protected WIOService getWIOService() {
        return WIOService.getInstance();
    }

    protected void incNumFiles() throws Exception {
        WIOService wioService = this.getWIOService();
        int MAX_NUM_FILES = wioService.getMaxOpenedFiles();
        if (this.numFiles >= MAX_NUM_FILES) {
            String err = "Overflow em numero de arquivos abertos no projeto.";
            Server.logSevereMessage("Overflow em numero de arquivos abertos no projeto.");
            throw new Exception("Overflow em numero de arquivos abertos no projeto.");
        }
        ++this.numFiles;
        this.fileSystem.incNumFiles();
    }

    private String[] mountServerPath(String path) throws Exception {
        if (path == null) {
            String err = "Path nulo para mountServerPath() : " + this.toString();
            throw new Exception(err);
        }
        String[] result = FileUtils.splitPath((String)path);
        if (result == null) {
            String err = "Falha de split em mountServerPath() : " + this.toString();
            throw new Exception(err);
        }
        return result;
    }

    public void moveFile(String fromPath, String toPath) throws WIOServiceException {
        try {
            try {
                ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
                String[] fromSrvPath = this.mountServerPath(fromPath);
                String[] toSrvPath = this.mountServerPath(toPath);
                this.checkExists(fromSrvPath);
                java.lang.Object pid = this.getMyProjectId();
                projectService.moveFile(pid, fromSrvPath, toSrvPath);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha de moveFile", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        finally {
            ProjectService.setUserId(null);
        }
    }

    public void renameFile(String path, String newName) throws WIOServiceException {
        try {
            try {
                String[] srvPath = this.mountServerPath(path);
                this.checkExists(srvPath);
                ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
                java.lang.Object pid = this.getMyProjectId();
                projectService.renameFile(pid, srvPath, newName);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha de renameFile", e);
                throw new WIOServiceException(WIOService.getExceptionString(e));
            }
        }
        finally {
            ProjectService.setUserId(null);
        }
    }

    protected void setDescription(String path, String description) throws Exception {
        String[] srvPath = this.mountServerPath(path);
        this.checkExists(srvPath);
        String text = description == null ? "<null>" : description;
        ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
        java.lang.Object pid = this.getMyProjectId();
        projectService.setFileDescription(pid, srvPath, text);
        ProjectService.setUserId(null);
    }

    protected void setUnderConstruction(String path, boolean flag) throws Exception {
        String[] srvPath = this.mountServerPath(path);
        this.checkExists(srvPath);
        ProjectService projectService = this.getProjectServiceWithThreadUserAdjusted();
        java.lang.Object pid = this.getMyProjectId();
        projectService.setUnderConstruction(pid, srvPath, flag);
        ProjectService.setUserId(null);
    }

    public String toString() {
        java.lang.Object uid = this.getMyUserId();
        java.lang.Object pid = this.getMyProjectId();
        String userText = "usu\u00e1rio nulo";
        if (uid != null) {
            userText = uid.toString();
        }
        String prjText = "projeto nulo";
        if (pid != null) {
            prjText = pid.toString();
        }
        return "[WIO Project]: " + userText + "@" + prjText;
    }

    protected WIOServerProject(WIOServerFileSystem fs, String userLogin, String ownerLogin, String projectName) throws Exception {
        if (userLogin == null || ownerLogin == null || projectName == null) {
            String err = "Usuarios/projeto desconhecidos em WIOServerProject";
            throw new Exception("Usuarios/projeto desconhecidos em WIOServerProject");
        }
        if (fs == null) {
            String err = "File-system nao identificado em WIOServerProject";
            throw new Exception("File-system nao identificado em WIOServerProject");
        }
        this.projectName = projectName;
        this.fileSystem = fs;
        this.userLogin = userLogin;
        this.ownerLogin = ownerLogin;
        this.fileSystem.incNumProjects();
        String fmt = "Projeto '%s' do usuario %s aberto pelo usu\u00e1rio %s.";
        String msg = String.format("Projeto '%s' do usuario %s aberto pelo usu\u00e1rio %s.", projectName, ownerLogin, userLogin);
        Server.logInfoMessage(msg);
    }
}

