/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.wioservice;

import csbase.logic.User;
import csbase.remote.WIOServiceInterface;
import csbase.server.Server;
import csbase.server.ServerEntryPointImpl;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.wioservice.ORBDealer;
import csbase.server.services.wioservice.WIOAudit;
import csbase.server.services.wioservice.WIOServerFileSystem;
import csbase.server.services.wioservice.idl.AlgorithmInfo;
import csbase.server.services.wioservice.idl.AlgorithmParameter;
import csbase.server.services.wioservice.idl.WIOServiceException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class WIOService
extends Service
implements WIOServiceInterface {
    private int maxNumProjects = -9;
    private int maxNumFiles = -9;
    private int maxReadKb = -9;
    private int maxWriteKb = -9;
    private WIOServerFileSystem wioFileSystem = null;
    private ORBDealer orbDealer = null;
    WIOAudit audit = null;
    private String serverPortText;

    public static void createService() throws ServerException {
        new WIOService();
    }

    public static String getExceptionString(Exception e) {
        String err = e.getMessage();
        err = err == null ? "<null>" : err;
        err = err.replaceAll("[^\\p{ASCII}]", "?");
        return err;
    }

    public static final WIOService getInstance() {
        return (WIOService)WIOService.getInstance("WIOService");
    }

    protected final POA activateCorbaObject(String id, Servant o) throws WIOServiceException {
        if (this.orbDealer == null) {
            String err = "Sem ORB dealer na ativacao CORBA [" + o.toString() + "]";
            WIOServiceException exception = new WIOServiceException(err);
            Server.logSevereMessage(err);
            throw exception;
        }
        return this.orbDealer.activateObject(id, o);
    }

    private void createAuditThread() {
        int FIVE_SECONDS = 5;
        int ONE_HOUR = 3600;
        int timeSec = this.getIntProperty("auditIntervalSeconds");
        if (timeSec < 5) {
            timeSec = 5;
        }
        if (timeSec > 3600) {
            timeSec = 3600;
        }
        Server.logInfoMessage("Intervalo de auditagem: " + timeSec + " s.");
        this.audit = new WIOAudit(this, timeSec * 1000);
    }

    protected final void deactivateCorbaObject(Servant o) throws WIOServiceException {
        if (this.orbDealer == null) {
            String err = "Sem ORB na desativacao: [" + o.toString() + "]";
            WIOServiceException exception = new WIOServiceException(err);
            Server.logSevereMessage(err);
            throw exception;
        }
        this.orbDealer.deactivateObject(o);
    }

    public final int getMaxReadKb() {
        return this.maxReadKb;
    }

    public final int getMaxWriteKb() {
        return this.maxWriteKb;
    }

    private int getPositiveInt(String propName) {
        int prp = this.getIntProperty(propName);
        return Math.abs(prp);
    }

    protected final boolean has2Update(Object arg, Object event) {
        return true;
    }

    private void initORB() throws ServerException {
        try {
            Server.logInfoMessage("Acessando ambiente ORB...");
            Properties props = this.getExternalPropertyFile("ORB.file");
            if (!this.isPropertyNull("ORB.port")) {
                int port = this.getIntProperty("ORB.port");
                String portStr = Integer.toString(port);
                props.setProperty("OAPort", portStr);
            }
            if (!this.isPropertyNull("ORB.hostAddr")) {
                String addr = this.getStringProperty("ORB.hostAddr");
                props.setProperty("OAIAddr", addr);
            }
            this.orbDealer = new ORBDealer(props);
            this.serverPortText = props.getProperty("OAPort");
            if (this.serverPortText == null) {
                String err = "WIO/ORB n\u00e3o est\u00e1 com ajuste OAPort!";
                throw new ServerException("WIO/ORB n\u00e3o est\u00e1 com ajuste OAPort!");
            }
            this.serverPortText = this.serverPortText.trim();
            String fmt = "Acesso ao ambiente WIO/ORB feito (porta '%s').";
            String msg = String.format("Acesso ao ambiente WIO/ORB feito (porta '%s').", this.serverPortText);
            Server.logInfoMessage(msg);
        }
        catch (Exception e) {
            throw new ServerException("Imposs\u00edvel criar servidor CORBA", e);
        }
        try {
            Server.logFineMessage("Instanciando FS remoto...");
            this.wioFileSystem = new WIOServerFileSystem(this);
            Server.logFineMessage("Ativando CORBA FS remoto...");
            this.orbDealer.activateObject("WIOFileSystem", (Servant)this.wioFileSystem);
            Server.logFineMessage("FS remoto ativado!");
        }
        catch (Exception e) {
            throw new ServerException("Imposs\u00edvel criar handler para o FS remoto", e);
        }
    }

    @Override
    public final void initService() throws ServerException {
        this.initORB();
        this.readConfiguration();
        this.createAuditThread();
    }

    public String preLogin2Web(String login, String password, String projectName, AlgorithmInfo algorithmInfo) {
        Object userId;
        ServerEntryPointImpl entryPoint = (ServerEntryPointImpl)Server.getInstance().getEntryPoint();
        if (entryPoint == null) {
            return null;
        }
        try {
            User user = User.getUserByLogin((String)login);
            userId = user.getId();
        }
        catch (Exception e) {
            return null;
        }
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        ProjectService projectService = ProjectService.getInstance();
        Object projectId = projectService.getProjectId(userId, projectName);
        attributes.put("project_name", (Serializable)((Object)projectId.toString()));
        attributes.put("algorithm_name", (Serializable)((Object)algorithmInfo.algorithmName));
        HashMap<String, String> algorithmParameters = new HashMap<String, String>();
        AlgorithmParameter[] algorithmParameterArray = algorithmInfo.parameters;
        int n = algorithmInfo.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            AlgorithmParameter parameter = algorithmParameterArray[n2];
            algorithmParameters.put(parameter.name, parameter.value);
            ++n2;
        }
        attributes.put("algorithm_parameters", algorithmParameters);
        return entryPoint.preLogin2Web(login, password, new Locale("pt", "BR"), attributes);
    }

    private void readConfiguration() {
        this.maxWriteKb = this.getPositiveInt("maxWriteSizeKb");
        this.maxReadKb = this.getPositiveInt("maxReadSizeKb");
        this.maxNumFiles = this.getPositiveInt("maxOpenedFiles");
        this.maxNumProjects = this.getPositiveInt("maxOpenedProjects");
        Server.logInfoMessage("Tam. m\u00e1ximo de leitura: " + this.maxReadKb + " Kb");
        Server.logInfoMessage("Tam. m\u00e1ximo de escrita: " + this.maxWriteKb + " Kb");
        Server.logInfoMessage("# Max. de arquivos por projeto: " + this.maxNumFiles);
        Server.logInfoMessage("# Max de projetos: " + this.maxNumProjects);
    }

    @Override
    public final void shutdownService() throws ServerException {
        try {
            if (this.orbDealer != null) {
                this.orbDealer.shutdown();
            }
            this.wioFileSystem = null;
            this.orbDealer = null;
            this.audit.finish();
        }
        catch (Exception e) {
            throw new ServerException("Imposs\u00edvel desativar servidor CORBA", e);
        }
    }

    protected WIOService() throws ServerException {
        super("WIOService");
    }

    int getMaxOpenedFiles() {
        return this.maxNumFiles;
    }

    int getMaxOpenedProjects() {
        return this.maxNumProjects;
    }

    int getNumOpenedFiles() {
        return this.wioFileSystem.getNumOpenedFiles();
    }

    int getNumOpenedProjects() {
        return this.wioFileSystem.getNumOpenedProjects();
    }

    public String getServerPort() {
        return this.serverPortText;
    }
}

