/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.wioservice;

import csbase.server.Server;
import csbase.server.services.eventlogservice.EventLogService;
import csbase.server.services.wioservice.WIOService;

class WIOAudit {
    private Thread thread = null;
    private boolean exitFlag = false;
    private final WIOService service;
    private final long interval;

    private void createThread() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!WIOAudit.this.exitFlag) {
                    WIOAudit.this.doFileAudit();
                    WIOAudit.this.doProjectAudit();
                    try {
                        Thread.sleep(WIOAudit.this.interval);
                    }
                    catch (InterruptedException ie) {
                        Server.logWarningMessage("Monitora\u00e7\u00e3o interrompida!");
                    }
                }
                Server.logWarningMessage("Finalizando monitora\u00e7\u00e3o.");
            }
        });
        this.exitFlag = false;
        this.thread.start();
        Server.logFineMessage("Thread de auditagem instanciada para execu\u00e7\u00e3o.");
    }

    private void doFileAudit() {
        try {
            int num = this.service.getNumOpenedFiles();
            int max = this.service.getMaxOpenedFiles();
            this.logEvent("file", num, max);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na auditagem: " + e.getMessage());
        }
    }

    private void doProjectAudit() {
        try {
            int num = this.service.getNumOpenedProjects();
            int max = this.service.getMaxOpenedProjects();
            this.logEvent("project", num, max);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na auditagem: " + e.getMessage());
        }
    }

    public void finish() {
        this.exitFlag = true;
    }

    private void logEvent(String queue, int num, int max) {
        EventLogService eventService = EventLogService.getInstance();
        String[] reQueue = new String[]{"wio", queue};
        String[] info = new String[]{Integer.toString(num), Integer.toString(max)};
        try {
            eventService.addServerInformation(reQueue, info);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de log de eventos " + e.getMessage());
        }
    }

    public WIOAudit(WIOService srv, long itv) {
        this.service = srv;
        this.interval = itv;
        this.createThread();
    }
}

