/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_00;

import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_00.ProjectDataService;
import tecgraf.openbus.data_service.DataAccessDenied;
import tecgraf.openbus.data_service.DataDescription;
import tecgraf.openbus.data_service.DataNotFound;
import tecgraf.openbus.data_service.DataView;
import tecgraf.openbus.data_service.IHierarchicalDataServicePOA;
import tecgraf.openbus.data_service.InvalidDataKey;
import tecgraf.openbus.data_service.InvalidPrototype;
import tecgraf.openbus.data_service.ServiceFailure;
import tecgraf.openbus.data_service.UnknownViewInterface;
import tecgraf.openbus.data_service.UnknownViews;

public final class IHierarchicalDataServiceServant
extends IHierarchicalDataServicePOA {
    public DataDescription[] getRoots() throws ServiceFailure, DataAccessDenied {
        String userId = OpenBusService.getInstance().getRequesterUserId();
        Service.setUserId(userId);
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription[] dataDescriptionArray = service.getRoots();
            return dataDescriptionArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataDescription[] getChildren(byte[] fKey) throws ServiceFailure, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription[] dataDescriptionArray = service.getChildren(fKey);
            return dataDescriptionArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataDescription getParent(byte[] fKey) throws ServiceFailure, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription dataDescription = service.getParent(fKey);
            return dataDescription;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataDescription getDataDescription(byte[] fKey) throws ServiceFailure, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription dataDescription = service.getDataDescription(fKey);
            return dataDescription;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataView getDataView(byte[] fKey, String fViewInterface) throws ServiceFailure, UnknownViewInterface, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataView dataView = service.getDataView(fKey, fViewInterface);
            return dataView;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataView[] getDataViewSeq(byte[][] fKeys, String fViewInterface) throws ServiceFailure, UnknownViewInterface, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataView[] dataViewArray = service.getDataViewSeq(fKeys, fViewInterface);
            return dataViewArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public byte[] createData(byte[] fParentKey, DataDescription fPrototype) throws ServiceFailure, DataNotFound, InvalidDataKey, DataAccessDenied, InvalidPrototype {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            byte[] byArray = service.createData(fParentKey, fPrototype);
            return byArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public byte[] copyData(byte[] fParentKey, byte[] fSourceKey) throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            byte[] byArray = service.copyData(fParentKey, fSourceKey);
            return byArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public void updateData(byte[] fKey, byte[] fSourceKey) throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            service.updateData(fKey, fSourceKey);
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public void moveData(byte[] fKey, byte[] fNewParentKey) throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            service.moveData(fKey, fNewParentKey);
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public void deleteData(byte[] fKey) throws ServiceFailure, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            service.deleteData(fKey);
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public byte[] copyDataFrom(byte[] fParentKey, byte[] fSourceKey) throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            byte[] byArray = service.copyDataFrom(fParentKey, fSourceKey);
            return byArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public void updateDataFrom(byte[] fKey, byte[] fSourceKey) throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey, DataAccessDenied {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            service.updateDataFrom(fKey, fSourceKey);
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }
}

