package csbase.server.services.administrationservice;

import java.util.List;

import csbase.logic.Permission;

/**
 * Implementao padro do DAO de permisso. Utiliza armazenamento em arquivo
 * (serializao de objetos).
 * 
 * @see DefaultAdministrationDAOFactory
 * @author Jorge Alexandre
 * 
 */
public class DefaultPermissionDAO implements PermissionDAO {

  private final PermissionIO permissionRepository;

  public DefaultPermissionDAO() {
    this.permissionRepository = new PermissionIO();
  }

  public Permission createPermission(Permission permission) throws DAOException {
    Permission result;
    try {
      result = permissionRepository.writeNew(permission);
    }
    catch (Exception e) {
      throw new DAOException(e, permission.toString());
    }
    if (result == null) {
      throw new DAOException("Falha em PermissionIO.writeNew", permission
        .toString());
    }
    return result;
  }

  public void deletePermission(Object id) throws DAOException {
    try {
      permissionRepository.delete(id);
    }
    catch (Exception e) {
      throw new DAOException(e, "id: " + id);
    }
  }

  public Permission modifyPermission(Object id, Permission permission)
    throws DAOException {
    Permission result;
    try {
      result = permissionRepository.write(id, permission);
    }
    catch (Exception e) {
      throw new DAOException(e, permission.toString());
    }
    if (result == null) {
      throw new DAOException("Falha em PermissionIO.write", permission
        .toString()
        + " - para o usurio: " + id);
    }
    return result;
  }

  public List<Permission> readAllPermissions() throws DAOException {
    return permissionRepository.readAll();
  }

  public Permission readPermission(Object id) throws DAOException {
    try {
      return permissionRepository.read(id);
    }
    catch (Exception e) {
      throw new DAOException(e, "id: " + id);
    }
  }
}
