/**
 * $Id$
 */
package csbase.server;

import java.util.Arrays;
import java.util.Locale;

import csbase.logic.ObserverData;
import csbase.remote.RemoteObjectObservable;

/**
 * 
 * 
 * @author Tecgraf
 */
public abstract class ServerRemoteObjectObservable extends
  RemoteObjectObservable {

  /**
   * Construtor.
   * 
   * @param locale Locale.
   */
  public ServerRemoteObjectObservable(Locale locale) {
    super(locale);
  }

  private StringBuffer buildMessage(ObserverData observerData, Object event,
    Exception e) {

    StringBuffer msg = new StringBuffer();

    msg.append("Erro na notificao de observador: ");
    msg.append(e.toString());
    msg.append(". Observador: ");
    msg.append(observerData.toString());
    msg.append(". Evento: ");
    if (event instanceof Object[]) {
      msg.append(Arrays.toString((Object[]) event));
    }
    else {
      msg.append(event.toString());
    }

    return msg;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleFatalError(ObserverData observerData, Object event,
    Exception e) {
    StringBuffer log = buildMessage(observerData, event, e);
    log.append(". Observador foi descadastrado.");
    Server.logSevereMessage(log.toString());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleException(ObserverData observerData, Object event,
    Exception e) {
    StringBuffer log = buildMessage(observerData, event, e);
    Server.logSevereMessage(log.toString(), e);
  }
}
