/*
 * $Id: BasicCentralServerMonitor.java 149913 2014-02-18 19:26:51Z pietroguedes $
 */
package csbase.server;

import csbase.logic.ServerURI;

/**
 * A classe <code>BasicCentralServerMonitor</code>  uma implementao de
 * <code>RemoteMonitor</code> para uso por um servidor local de um sistema
 * construdo a partir do CSBASE. Este componente  configurvel para cada
 * sistema. A configurao deste componente compreende: - o nome do sistema em
 * questo - o nome do servidor monitorado - a classe que mantm as referncias
 * para os servios remotos (a especializao de
 * <code>ServerRemoteLocator</code> para o sistema)
 * 
 * @author Tecgraf/PUC-Rio
 */
public class BasicCentralServerMonitor extends LocalServerRemoteMonitor {

  /**
   * Constri o monitor conforme a configurao de um sistema especfico.
   * 
   * @param systemName nome do sistema
   * @param serverURI URI do servidor
   * @param locator classe que mantm as referncias para os objetos remotos
   */
  public BasicCentralServerMonitor(final String systemName,
    final ServerURI serverURI, final Class<?> locator) {
    this(systemName, serverURI, locator, 0);
  }

  /**
   * Constri o monitor conforme a configurao de um sistema especfico.
   * 
   * @param systemName nome do sistema
   * @param serverURI URI do servidor
   * @param locator classe que mantm as referncias para os objetos remotos
   * @param windowSize Valor mximo da janela de backoff.
   */
  public BasicCentralServerMonitor(final String systemName,
    final ServerURI serverURI, final Class<?> locator, int windowSize) {
    super(serverURI, locator, windowSize);
  }
}
