/**
 * $Id$
 */
package csbase.server.services.projectservice.v1_02;

import tecgraf.openbus.data_service.core.v1_02.AbsentViews;
import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataAlreadyExist;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.core.v1_02.UnavailableDataService;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalTransferDataServiceOperations;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalTransferDataServicePOA;
import tecgraf.openbus.data_service.hierarchical.v1_02.InvalidContainer;
import tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * 
 * 
 * @author Tecgraf
 */
public class IHierarchicalTransferDataServiceServant extends
  IHierarchicalTransferDataServicePOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public byte[] copyDataFrom(byte[] fSourceKey, byte[] fParentKey)
    throws UnavailableDataService, ServiceFailure, DataAlreadyExist,
    DataNotFound, DataAccessDenied, AbsentViews, UnsupportedOperation,
    InvalidDataKey, InvalidContainer {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalTransferDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.copyDataFrom(fSourceKey, fParentKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void updateDataFrom(byte[] fKey, byte[] fSourceKey)
    throws UnavailableDataService, ServiceFailure, DataNotFound,
    DataAccessDenied, AbsentViews, InvalidDataKey {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalTransferDataServiceOperations service =
        ProjectDataService.getInstance();
      service.updateDataFrom(fKey, fSourceKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }
}
