package csbase.server.services.schedulerservice;

import java.util.List;

import csbase.logic.CommandInfo;

/**
 * Interface das classes que implementam as polticas de escalonamento que podem 
 * ser empregadas pelo SchedulerService.
 * 
 * @author valeria
 *
 */
public interface SchedulerPolicyInterface {
  /**
   * Escolhe, dentre os servidores SGAs dados, um para processar o comando.
   * 
   * @param command Comando para execuo
   * @param serversNames Lista de todos os servidores disponveis
   * @return O servidor escolhido para execuo do comando.
   */
  public String chooseServer(CommandInfo command, List<String> serversNames);
  
  /**
   * Escolhe, dentre os servidores dados, um conjunto para processar o comando.
   * 
   * @param command Comando para execuo
   * @param serversNames Lista com todos os servidores disponveis
   * @param numServers Nmero de servidores a serem escolhidos
   * @return Uma lista com os servidores escolhidos para execuo do comando.
   */
  public List<String> chooseServers(CommandInfo command, 
                             List<String> serversNames, 
                             int numServers);
}
