/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.IdFactory;
import csbase.logic.Permission;
import csbase.logic.Role;
import csbase.logic.RoleInfo;
import csbase.server.Server;
import csbase.server.services.administrationservice.AdministrationService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class RoleIO {
    private IdFactory idFactory;
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String PERMISSIONS = "permissions";
    private static String FILENAME_PROPERTY = "RoleIO.filename";
    private static String FILENAME;
    private static String fileName;

    public static void main(String[] args) throws Exception {
        RoleIO.printDataFile();
    }

    public RoleIO() {
        Server server = Server.getInstance();
        AdministrationService admSrv = AdministrationService.getInstance();
        fileName = server.getPersistencyRootDirectoryName() + File.separator + admSrv.getStringProperty(FILENAME_PROPERTY);
        Server.logInfoMessage("RoleIO.RoleIO: Arquivo de perfis: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Role> readAll() throws Exception {
        AdministrationService srv = AdministrationService.getInstance();
        Vector<Role> allRoles = new Vector<Role>();
        File rolesFile = new File(fileName);
        if (!rolesFile.exists()) {
            Server.logInfoMessage("Criando novo arquivo de perfis " + fileName);
            return allRoles;
        }
        try (ObjectInputStream in = null;){
            in = new ObjectInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(rolesFile))));
            Hashtable roles = (Hashtable)in.readObject();
            boolean allRead = true;
            for (Map.Entry roleEntry : roles.entrySet()) {
                Object[] permissions;
                String desc;
                Hashtable roleHash;
                String name;
                Object id = roleEntry.getKey();
                Role role = new Role(id, new RoleInfo(name = (String)(roleHash = (Hashtable)roleEntry.getValue()).get(NAME), desc = (String)roleHash.get(DESCRIPTION), permissions = (Object[])roleHash.get(PERMISSIONS)));
                if (!this.checkPermissions(role)) {
                    allRead = false;
                }
                allRoles.add(role);
            }
            if (!allRead) {
                try {
                    Server.logInfoMessage("Persistindo os perfis apenas com permiss\u00f5es v\u00e1lidas.");
                    this.writeAll(allRoles);
                }
                catch (Exception e) {
                    Server.logSevereMessage("Falha na persistencia dos perfis com apenas permiss\u00f5es v\u00e1lidas.", e);
                }
            }
        }
        return allRoles;
    }

    private boolean checkPermissions(Role role) {
        AdministrationService srv = AdministrationService.getInstance();
        Object[] ids = role.getPermissionIds();
        boolean result = true;
        int lostPermissions = 0;
        for (int i = 0; i < ids.length; ++i) {
            Permission p = null;
            try {
                p = Permission.getPermission((Object)ids[i]);
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro ao obter permiss\u00e3o " + ids[i], e);
            }
            if (p != null) continue;
            Server.logSevereMessage("Permiss\u00e3o inexistente sendo removida do perfil " + role.getName() + ": " + ids[i]);
            ids[i] = null;
            ++lostPermissions;
        }
        if (lostPermissions > 0) {
            Object[] newIds = new Object[ids.length - lostPermissions];
            int n = 0;
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == null) continue;
                newIds[n++] = ids[i];
            }
            role.setPermissionIds(newIds);
            result = false;
        }
        return result;
    }

    public synchronized Role read(Object id) throws Exception {
        List roles = Role.getAllRoles();
        for (Role role : roles) {
            if (!role.getId().equals(id)) continue;
            return role;
        }
        return null;
    }

    public synchronized Role writeNew(RoleInfo info) throws Exception {
        try {
            List roles = Role.getAllRoles();
            if (this.idFactory == null) {
                this.idFactory = new IdFactory(roles);
            }
            Object id = this.idFactory.next();
            Role role = new Role(id, info);
            roles.add(role);
            this.writeAll(roles);
            return role;
        }
        catch (Exception e) {
            throw new IOException("Arquivo de perfis corrompido");
        }
    }

    public synchronized Role write(Object id, RoleInfo info) throws Exception {
        try {
            Role role = Role.getRole((Object)id);
            List roles = Role.getAllRoles();
            if (!roles.remove(role)) {
                throw new Exception("Perfil n\u00e3o existe");
            }
            role = new Role(id, info);
            roles.add(role);
            this.writeAll(roles);
            return role;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public synchronized void delete(Object id) throws Exception {
        List roles;
        Role role;
        try {
            role = Role.getRole((Object)id);
            roles = Role.getAllRoles();
            if (this.idFactory == null) {
                this.idFactory = new IdFactory(roles);
            }
        }
        catch (Exception e) {
            throw new IOException();
        }
        if (!roles.remove(role)) {
            throw new Exception("Perfil n\u00e3o existe");
        }
        this.writeAll(roles);
        this.idFactory.free(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeAll(List<Role> roleList) throws Exception {
        Hashtable roles = new Hashtable();
        for (Role role : roleList) {
            Hashtable<String, Object> roleHash = new Hashtable<String, Object>();
            roleHash.put(NAME, role.getName());
            roleHash.put(DESCRIPTION, role.getDescription());
            roleHash.put(PERMISSIONS, role.getPermissionIds());
            roles.put(role.getId(), roleHash);
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName))));){
            out.writeObject(roles);
        }
    }

    public static void printDataFile() {
    }

    static {
        fileName = FILENAME = "role.dat";
    }
}

