/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.IdFactory;
import csbase.logic.UserGroup;
import csbase.logic.UserGroupInfo;
import csbase.server.Server;
import csbase.server.services.administrationservice.AdministrationService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class UserGroupIO {
    protected IdFactory idFactory;
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static String FILENAME_PROPERTY = "UserGroupIO.filename";
    private static String FILENAME;
    private static String fileName;

    public UserGroupIO() {
        Server server = Server.getInstance();
        AdministrationService service = AdministrationService.getInstance();
        fileName = server.getPersistencyRootDirectoryName() + File.separator + service.getStringProperty(FILENAME_PROPERTY);
        Server.logInfoMessage("Arquivo de UserGroups: " + fileName);
    }

    public static void main(String[] args) throws IOException {
        new UserGroupIO().printDataFile();
    }

    public void printDataFile() throws IOException {
        try {
            for (UserGroup userGroup : this.readAll()) {
                System.out.println(userGroup);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public synchronized UserGroup writeNew(UserGroupInfo info) throws IOException {
        try {
            List userGroups = UserGroup.getAllUserGroups();
            if (this.idFactory == null) {
                this.idFactory = new IdFactory(userGroups);
            }
            Object id = this.idFactory.next();
            UserGroup userGroup = new UserGroup(id, info);
            userGroups.add(userGroup);
            this.writeAll(userGroups);
            return userGroup;
        }
        catch (Exception e) {
            throw new IOException("Arquivo de UserGroups corrompido");
        }
    }

    public synchronized UserGroup write(Object id, UserGroupInfo info) throws IOException {
        try {
            UserGroup oldUserGroup = UserGroup.getUserGroup((Object)id);
            List userGroups = UserGroup.getAllUserGroups();
            if (!userGroups.remove(oldUserGroup)) {
                throw new IOException("UserGroup n\u00e3o existe");
            }
            UserGroup userGroup = new UserGroup(id, info);
            userGroups.add(userGroup);
            this.writeAll(userGroups);
            return userGroup;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public synchronized void delete(Object id) throws IOException {
        List userGroups;
        UserGroup userGroup;
        try {
            userGroup = UserGroup.getUserGroup((Object)id);
            userGroups = UserGroup.getAllUserGroups();
            if (this.idFactory == null) {
                this.idFactory = new IdFactory(userGroups);
            }
        }
        catch (Exception e) {
            throw new IOException();
        }
        if (!userGroups.remove(userGroup)) {
            throw new IOException("UserGroup n\u00e3o existe");
        }
        this.writeAll(userGroups);
        this.idFactory.free(userGroup.getId());
    }

    public synchronized UserGroup read(Object id) throws IOException {
        try {
            List userGroups = UserGroup.getAllUserGroups();
            for (UserGroup userGroup : userGroups) {
                if (!userGroup.getId().equals(id)) continue;
                return userGroup;
            }
            return null;
        }
        catch (Exception e) {
            throw new IOException("Arquivo de UserGroups corrompido");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<UserGroup> readAll() throws IOException {
        Vector<UserGroup> userGroupsList = new Vector<UserGroup>();
        File userGroupsFile = new File(fileName);
        if (!userGroupsFile.exists()) {
            AdministrationService srv = AdministrationService.getInstance();
            Server.logInfoMessage("Criando novo arquivo de grupos de usu\u00e1rios " + fileName);
            return userGroupsList;
        }
        try (ObjectInputStream in = null;){
            in = new ObjectInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(userGroupsFile))));
            Hashtable userGroupsHash = (Hashtable)in.readObject();
            for (Map.Entry ugEntry : userGroupsHash.entrySet()) {
                Object id = ugEntry.getKey();
                Hashtable userGroupHash = (Hashtable)ugEntry.getValue();
                String name = (String)userGroupHash.get(NAME);
                String desc = (String)userGroupHash.get(DESCRIPTION);
                userGroupsList.add(new UserGroup(id, new UserGroupInfo(name, desc)));
            }
            Vector<UserGroup> vector = userGroupsList;
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeAll(List<UserGroup> userGroups) throws IOException {
        Hashtable userGroupsHash = new Hashtable();
        for (int i = 0; i < userGroups.size(); ++i) {
            UserGroup userGroup = userGroups.get(i);
            Hashtable<String, String> userGroupHash = new Hashtable<String, String>();
            userGroupHash.put(NAME, userGroup.getName());
            userGroupHash.put(DESCRIPTION, userGroup.getDesc());
            userGroupsHash.put(userGroup.getId(), userGroupHash);
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName))));){
            out.writeObject(userGroupsHash);
        }
    }

    static {
        fileName = FILENAME = "usergroup.dat";
    }
}

