/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CapacityType;
import csbase.logic.SGASet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public class SGASetCPUAndIOComparator
implements Comparator<SGASet>,
Serializable {
    private long minWritingCap;
    private long maxWritingCap;
    private long minSendCap;
    private long maxSendCap;
    private double minProcCap;
    private double maxProcCap;

    public SGASetCPUAndIOComparator(List<String> serversNames, long minWritingCap, long maxWritingCap, double minProcCap, double maxProcCap, long minSendCap, long maxSendCap) {
        this.minWritingCap = minWritingCap;
        this.maxWritingCap = maxWritingCap;
        this.minProcCap = minProcCap;
        this.maxProcCap = maxProcCap;
        this.minSendCap = minSendCap;
        this.maxSendCap = maxSendCap;
    }

    @Override
    public int compare(SGASet sga1, SGASet sga2) {
        double cpuCap2;
        double cpuCap1;
        double sgaTransfer2;
        double sgaTransfer1;
        double sgaWriting2;
        double sgaWriting1;
        if (this.minWritingCap == this.maxWritingCap) {
            sgaWriting1 = 1.0;
            sgaWriting2 = 1.0;
        } else {
            sgaWriting1 = sga1.getCapacity(CapacityType.DISK_WRITE);
            sgaWriting2 = sga2.getCapacity(CapacityType.DISK_WRITE);
            if (sgaWriting1 == -1.0) {
                sgaWriting1 = this.minWritingCap;
            }
            if (sgaWriting2 == -1.0) {
                sgaWriting2 = this.maxWritingCap;
            }
            sgaWriting1 = (sgaWriting1 - (double)this.minWritingCap) / (double)(this.maxWritingCap - this.minWritingCap);
            sgaWriting2 = (sgaWriting2 - (double)this.minWritingCap) / (double)(this.maxWritingCap - this.minWritingCap);
        }
        if (this.minSendCap == this.maxSendCap) {
            sgaTransfer1 = 1.0;
            sgaTransfer2 = 1.0;
        } else {
            sgaTransfer1 = sga1.getCapacity(CapacityType.NET);
            sgaTransfer2 = sga2.getCapacity(CapacityType.NET);
            if (sgaTransfer1 == -1.0) {
                sgaTransfer1 = this.minSendCap;
            } else if (sgaTransfer1 == -2.0) {
                sgaTransfer1 = this.maxSendCap;
            }
            if (sgaTransfer2 == -1.0) {
                sgaTransfer2 = this.minSendCap;
            } else if (sgaTransfer2 == -2.0) {
                sgaTransfer2 = this.maxSendCap;
            }
            sgaTransfer1 = (sgaTransfer1 - (double)this.minSendCap) / (double)(this.maxSendCap - this.minSendCap);
            sgaTransfer2 = (sgaTransfer2 - (double)this.minSendCap) / (double)(this.maxSendCap - this.minSendCap);
        }
        if (this.minProcCap == this.maxProcCap) {
            cpuCap1 = 1.0;
            cpuCap2 = 1.0;
        } else {
            cpuCap1 = sga1.getCapacity(CapacityType.CPU);
            cpuCap2 = sga2.getCapacity(CapacityType.CPU);
            if (cpuCap1 == -1.0) {
                cpuCap1 = 1.0;
            }
            if (cpuCap2 == -1.0) {
                cpuCap2 = 1.0;
            }
            cpuCap1 = 1.0 / (sga1.getCPULoad1() + 1.0) * cpuCap1;
            cpuCap1 = (cpuCap1 - this.minProcCap) / (this.maxProcCap - this.minProcCap);
            cpuCap2 = 1.0 / (sga2.getCPULoad1() + 1.0) * cpuCap2;
            cpuCap2 = (cpuCap2 - this.minProcCap) / (this.maxProcCap - this.minProcCap);
        }
        double execCap1 = 0.25 * sgaWriting1 + 0.25 * sgaTransfer1 + 0.5 * cpuCap1;
        double execCap2 = 0.25 * sgaWriting2 + 0.25 * sgaTransfer2 + 0.5 * cpuCap2;
        if (execCap1 > execCap2) {
            return -1;
        }
        if (execCap1 < execCap2) {
            return 1;
        }
        return 0;
    }
}

