/*
 * $Id:$
 */
package csbase.server;

import java.util.logging.Level;
import java.util.logging.LogRecord;

import csbase.logic.User;

/**
 * Classe usada para passar requisies de logs entre o servidor e o handler.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ServerLogRecord extends LogRecord {
  /**
   * Usurio que originou a chamada no servidor.
   */
  private final User user;
  /**
   * Identificao do mtodo que solicitou o log.
   */
  private StackTraceElement method;

  /**
   * Retorna o usurio que originou a chamada no servidor.
   * 
   * @return o usurio
   */
  public User getUser() {
    return user;
  }

  /**
   * Retorna a identificao do mtodo que solicitou o log.
   * 
   * @return O mtodo que solicitou o log.
   */
  public StackTraceElement getMethod() {
    return method;
  }

  /**
   * Recupera o usurio corrente. Caso ocorra algum erro, retorna null.
   * 
   * @return O usurio corrente, ou nul caso ocorra algum erro.
   */
  private User getServiceUser() {
    try {
      return Service.getUser();
    }
    catch (Throwable t) {
      return null;
    }
  }

  /**
   * Construtor.
   * 
   * @param level Nvel de log.
   * @param msg Mensagem de log.
   * @param method Mtodo que solicitou o log.
   */
  public ServerLogRecord(final Level level, final String msg,
    StackTraceElement method) {
    super(level, msg);
    this.method = method;
    this.user = getServiceUser();
  }
}