/*
 * $Id$
 */
package csbase.server.services.algorithmservice;

import tecgraf.javautils.core.timestamp.TStamp64;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmsPack;

/**
 * Representa as informaes referentes ao dado (Pacote de Algoritmos)
 * necessrias para importao e consulta dos algoritmos contidos nele.
 * 
 */
public class ImportAlgorithmsPackDataInfo {
  /** Usurio que solicitou a importao do arquivo do Pacote de Algoritmos */
  private User user;

  /**
   * Token (timestamp) que identifica unicamente o arquivo do Pacote de
   * Algoritmos
   */
  private TStamp64 timestamp;

  /**
   * Estrutura do PA que corresponde  leitura do arquivo de metadados do pacote
   * de algoritmos
   */
  private AlgorithmsPack algoPackage;

  /**
   * Indica se esse dado j foi totalmente descomprimido no diretrio temporrio
   * identificado pelo token
   */
  private boolean isDescompressed;

  /**
   * Construtor
   * @param user usurio
   * @param timestamp timestamp
   */
  public ImportAlgorithmsPackDataInfo(User user, TStamp64 timestamp) {
    super();
    setUser(user);
    setTimestamp(timestamp);
    setAlgoPackage(null);
    setDescompressed(false);
  }

  /**
   * Construtor padro.
   */
  public ImportAlgorithmsPackDataInfo() {
  }

  /**
   * Retorna
   * 
   * @return user
   */
  public User getUser() {
    return user;
  }

  /**
   * Retorna
   * 
   * @return timestamp
   */
  public TStamp64 getToken() {
    return timestamp;
  }

  /**
   * Retorna
   * 
   * @return algoPackage pacote de algoritmo.
   */
  public AlgorithmsPack getAlgoPackage() {
    return algoPackage;
  }

  /**
   * @param algoPackage pacote de algoritmo.
   */
  public void setAlgoPackage(AlgorithmsPack algoPackage) {
    this.algoPackage = algoPackage;
  }

  /**
   * @param user usurio.
   */
  protected void setUser(User user) {
    this.user = user;
  }

  /**
   * @param timestamp tempo
   */
  protected void setTimestamp(TStamp64 timestamp) {
    this.timestamp = timestamp;
  }

  /**
   * @param wasDescompressed indicativo.
   */
  public void setDescompressed(boolean wasDescompressed) {
    this.isDescompressed = wasDescompressed;
  }

  /**
   * Retorna indicativo de compresso.
   * 
   * @return indicativo.
   */
  public boolean isDescompressed() {
    return isDescompressed;
  }

}
