package csbase.server.services.opendreamsservice.opendreams.v1_04;

import java.util.Properties;

import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.openbusservice.OpenBusServiceFacet;
import csbase.server.services.openbusservice.OpenBusServiceOffer;

/**
 * 
 * Cria a configurao para o OpenDreamsService da verso 1.2
 * 
 * @author Tecgraf PUC-Rio
 */
public class OpenDreamsServiceOffer implements OpenBusServiceOffer {

  @Override
  public OpenBusServiceFacet[] getFacets() {
    return new OpenBusServiceFacet[] { new OpenBusServiceFacet(
      "opendreams",
      tecgraf.openbus.opendreams.IOpenDreamsHelper.id(),
      new csbase.server.services.opendreamsservice.opendreams.v1_04.OpenDreams()) };
  }

  @Override
  public Properties getProperties() {
    return null;
  }

  @Override
  public void registerFactories() {
    org.omg.CORBA_2_3.ORB orb =
      (org.omg.CORBA_2_3.ORB) OpenBusService.getInstance().getORB();
    orb.register_value_factory(
      tecgraf.openbus.opendreams.OpenDreamsJobTemplateHelper.id(),
      new tecgraf.openbus.opendreams.OpenDreamsJobTemplateFactory());
  }
}
