package csbase.server.services.projectservice.v1_00;

import tecgraf.openbus.data_service.DataAccessDenied;
import tecgraf.openbus.data_service.DataDescription;
import tecgraf.openbus.data_service.DataNotFound;
import tecgraf.openbus.data_service.DataView;
import tecgraf.openbus.data_service.IHierarchicalDataService;
import tecgraf.openbus.data_service.IHierarchicalDataServiceOperations;
import tecgraf.openbus.data_service.IHierarchicalDataServicePOA;
import tecgraf.openbus.data_service.InvalidDataKey;
import tecgraf.openbus.data_service.InvalidPrototype;
import tecgraf.openbus.data_service.ServiceFailure;
import tecgraf.openbus.data_service.UnknownViewInterface;
import tecgraf.openbus.data_service.UnknownViews;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * Classe que representa um proxy OpenBus do tipo
 * {@linkplain IHierarchicalDataService}
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class IHierarchicalDataServiceServant extends
  IHierarchicalDataServicePOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription[] getRoots() throws ServiceFailure, DataAccessDenied {
    String userId = OpenBusService.getInstance().getRequesterUserId();
    Service.setUserId(userId);
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getRoots();
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription[] getChildren(byte[] fKey) throws ServiceFailure,
    DataNotFound, InvalidDataKey, DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getChildren(fKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription getParent(byte[] fKey) throws ServiceFailure,
    DataNotFound, InvalidDataKey, DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getParent(fKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription getDataDescription(byte[] fKey) throws ServiceFailure,
    DataNotFound, InvalidDataKey, DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getDataDescription(fKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataView getDataView(byte[] fKey, String fViewInterface)
    throws ServiceFailure, UnknownViewInterface, DataNotFound, InvalidDataKey,
    DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getDataView(fKey, fViewInterface);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataView[] getDataViewSeq(byte[][] fKeys, String fViewInterface)
    throws ServiceFailure, UnknownViewInterface, DataNotFound, InvalidDataKey,
    DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getDataViewSeq(fKeys, fViewInterface);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public byte[] createData(byte[] fParentKey, DataDescription fPrototype)
    throws ServiceFailure, DataNotFound, InvalidDataKey, DataAccessDenied,
    InvalidPrototype {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.createData(fParentKey, fPrototype);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public byte[] copyData(byte[] fParentKey, byte[] fSourceKey)
    throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey,
    DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.copyData(fParentKey, fSourceKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void updateData(byte[] fKey, byte[] fSourceKey) throws ServiceFailure,
    UnknownViews, DataNotFound, InvalidDataKey, DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      service.updateData(fKey, fSourceKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void moveData(byte[] fKey, byte[] fNewParentKey)
    throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey,
    DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      service.moveData(fKey, fNewParentKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void deleteData(byte[] fKey) throws ServiceFailure, DataNotFound,
    InvalidDataKey, DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      service.deleteData(fKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public byte[] copyDataFrom(byte[] fParentKey, byte[] fSourceKey)
    throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey,
    DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.copyDataFrom(fParentKey, fSourceKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void updateDataFrom(byte[] fKey, byte[] fSourceKey)
    throws ServiceFailure, UnknownViews, DataNotFound, InvalidDataKey,
    DataAccessDenied {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalDataServiceOperations service =
        ProjectDataService.getInstance();
      service.updateDataFrom(fKey, fSourceKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }
}
