package csbase.server.services.restservice;

import java.io.IOException;
import java.util.Locale;

import javax.annotation.Priority;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.glassfish.hk2.api.ServiceLocator;

import ibase.common.RestErrorMessage;
import ibase.common.ServiceAdapter;
import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.authentication.v1.adapter.ParseException;

/**
 * Filtro que vai verificar credenciais ou tokens ou o que estiver sendo usado
 * para validar o usurio.
 * 
 * Alm disso ele executa configures necessrias antes do request.
 * 
 * @author Tecgraf/PUC-Rio
 */
@Priority(Priorities.AUTHENTICATION)
public class CSBaseRequestFilter implements ContainerRequestFilter {

  /** ServiceLocator defaul do jersey */
  @Context
  private ServiceLocator serviceLocator;

  /** URI base */
  @Context
  private UriInfo uriInfo;

  /**
   * Nome do parmetro opcional que todas as requisies podem ter para o locale
   */
  public static String LOCALE_PARAM = "locale";

  /**
   * {@inheritDoc}
   */
  @Override
  public void filter(ContainerRequestContext requestContext)
    throws IOException {

    ServiceAdapter.setServiceLocator(serviceLocator);
    ServiceAdapter.setURI(RestService.getInstance().getExternalURL());

    if (requestContext.getUriInfo().getPath().indexOf("authentication") < 0
      && requestContext.getUriInfo().getPath().indexOf("links") < 0
      && requestContext.getUriInfo().getPath().indexOf("swagger.yaml") < 0
      && requestContext.getUriInfo().getPath().indexOf("swagger.json") < 0) {

      String authorizationHeader = requestContext.getHeaderString(
        HttpHeaders.AUTHORIZATION);
      ServiceAdapter.setAuthorizationHeader(authorizationHeader);

      if (authorizationHeader == null || !authorizationHeader.startsWith(
        "Bearer ")) {
        requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED)
          .entity(new RestErrorMessage("Authorization header must be provided"))
          .build());
        return;
      }

      String token = authorizationHeader.substring("Bearer".length()).trim();

      AuthenticationService authenticationService = ServiceAdapter.getInstance(
        AuthenticationService.class, Locale.getDefault().toString());
      try {
        String userId = authenticationService.parserToken(token, null);
        ServiceAdapter.setCurrentUser(userId);
        requestContext.setProperty("userId", userId);
      }
      catch (ParseException e) {
        requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED)
          .build());
      }
    }
  }
}
