package csbase.server.services.restservice.websocket.utils;

import csbase.server.Server;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketUtils {

	private static final String WS_DIR = "wspersistence";

	/**
	 *
	 * @param keyExtractor
	 * @param <T>
	 * @return
	 */
	public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
		Map<Object, Boolean> seen = new ConcurrentHashMap<>();
		return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
	}

	/**
	 *
	 * @param test
	 * @return
	 */
	public static boolean isJSONValid(String test) {
		try {
			new JSONObject(test);
		} catch (JSONException ex) {
			try {
				new JSONArray(test);
			} catch (JSONException ex1) {
				return false;
			}
		}
		return true;
	}

	/**
	 * Generate path in server.
	 *
	 * @param filename
	 *            the desired filename
	 *
	 * @return absolute path.
	 */
	public static String generatePath(String filename) {
		String dir = WS_DIR;
		try {
			Server server = Server.getInstance();
			String sep = File.separator;
			String pName = server.getPersistencyRootDirectoryName();
			String dName = pName + sep + dir;
			Server.checkDirectory(dName);
			Server.logWarningMessage(dName + sep + filename);
			return dName + sep + filename;
		} catch (Throwable t) {
			Server.logSevereMessage(
					"Falha na criao do arquivo de persistncia " + dir + "/" + filename + " " + t.getMessage());
			return filename;
		}
	}

	public static void InitializeGrizzlyLogger() {
		Logger l = Logger.getLogger("org.glassfish.grizzly");
		l.setLevel(Level.INFO);
		l.setUseParentHandlers(false);
		ConsoleHandler ch = new ConsoleHandler();
		ch.setLevel(Level.INFO);
		l.addHandler(ch);
	}

}
