/*
 * $Id:$
 */
package csbase.server.services.filetransferservice.sftp;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.ChannelSftp.LsEntry;

import csbase.exception.ServiceFailureException;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferElement;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.server.services.filetransferservice.FileTransferJob;
import csbase.server.services.filetransferservice.FileTransferProtocolStub;

/**
 * Stub de implementao do protocolo SFTP.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class SFTPStub implements FileTransferProtocolStub {

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean checkConnection(final FileTransferConnection connection)
    throws ServiceFailureException {

    final String serverName = connection.getServerName();
    final String userName = connection.getUserName();
    final String password = connection.getPassword();

    JSch jsch = new JSch();
    final int port = 22;
    final Session session;
    try {
      session = jsch.getSession(userName, serverName, port);
    }
    catch (JSchException e) {
      throw new ServiceFailureException(e.getMessage());
    }

    final UserInfo ui = new StubUserInfo(password);
    session.setUserInfo(ui);
    try {
      session.connect();

      final Channel channel = session.openChannel("sftp");
      channel.connect();
      return true;
    }
    catch (Exception e) {
      return false;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public FileTransferJob createDownloadJob(final FileTransferRequest request)
    throws ServiceFailureException {
    final SFTPDownloadJob job = new SFTPDownloadJob(request);
    return job;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public FileTransferJob createUploadJob(final FileTransferRequest request)
    throws ServiceFailureException {
    final SFTPUploadJob job = new SFTPUploadJob(request);
    return job;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<FileTransferElement> listContent(
    final FileTransferConnection connection, final String remoteDirPath)
    throws ServiceFailureException {
    final String serverName = connection.getServerName();
    final String userName = connection.getUserName();
    final String password = connection.getPassword();

    // Path vazio (home) no funciona com SFTP. Estamos improvisando
    // com o uso do diretrio raiz.
    String rmtDirPath = remoteDirPath.trim();
    if (rmtDirPath.equals("")) {
      rmtDirPath = "/";
    }

    JSch jsch = new JSch();
    final int port = 22;
    final Session session;
    try {
      session = jsch.getSession(userName, serverName, port);
    }
    catch (JSchException e) {
      throw new ServiceFailureException(e.getMessage());
    }

    final ArrayList<FileTransferElement> elements =
      new ArrayList<FileTransferElement>();
    final UserInfo ui = new StubUserInfo(password);
    session.setUserInfo(ui);
    try {
      session.connect();
      final Channel c = session.openChannel("sftp");
      c.connect();
      final ChannelSftp channel = (ChannelSftp) c;
      final Vector<?> ls = channel.ls(remoteDirPath);
      if (ls != null) {
        for (int i = 0; i < ls.size(); i++) {
          Object obj = ls.elementAt(i);
          if (obj instanceof LsEntry) {
            final LsEntry entry = (LsEntry) obj;
            final String name = entry.getFilename();
            final SftpATTRS attrs = entry.getAttrs();
            final boolean isDir = attrs.isDir();
            final long size = attrs.getSize();
            final boolean isLink = attrs.isLink();
            final FileTransferElement elem =
              new FileTransferElement(name, isDir, size, isLink);
            elements.add(elem);
          }
        }
      }
      return elements;
    }
    catch (final Exception e) {
      throw new ServiceFailureException(e.getMessage());
    }
  }
}
