/**
 * $Id$
 */

package csbase.server.services.projectservice;

import csbase.logic.FileLockListenerInterface;

/**
 * Classe responsvel por observar no servidor quando um lock de arquivo 
 * obtido ou expirado.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ServerFileLockListener implements FileLockListenerInterface {

  /**
   * Indica se j chegou a notificao de que o lock foi obtido ou o pedido
   * expirou.
   */
  private boolean gotNotification;

  /**
   * Indica se conseguiu o lock.
   */
  private boolean locked;

  /**
   * Constri o listener que  notificado quando o lock  obtido ou expirado
   */
  public ServerFileLockListener() {
    this.gotNotification = false;
    this.locked = false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final void fileLocked(Object lockId) {
    locked = true;
    gotNotification();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final void fileLockExpired(Object lockId) {
    locked = false;
    gotNotification();
  }

  /**
   * Verifica se obteve a notificao. Se no, dorme at que a notificao 
   * obtida.
   * 
   * @return true se obteve o lock do arquivo
   */
  public synchronized boolean getLock() {
    while (!gotNotification) {
      try {
        wait();
      }
      catch (InterruptedException e) {
      }
    }
    return locked;
  }

  /**
   * Chegou a notificao de que o lock do arquivo foi obtido ou expirado.
   */
  private synchronized void gotNotification() {
    gotNotification = true;
    notifyAll();
  }

}
