package csbase.server.services.projectservice.v1_01;

import java.util.Properties;

import tecgraf.openbus.data_service.core.v1_01.IDataServiceHelper;
import tecgraf.openbus.data_service.core.v1_01.UnstructuredDataViewFactory;
import tecgraf.openbus.data_service.core.v1_01.UnstructuredDataViewHelper;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalManagementDataServiceHelper;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalNavigationDataServiceHelper;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalTransferDataServiceHelper;
import tecgraf.openbus.data_service.project.v1_01.IProjectNavigationDataServiceHelper;
import tecgraf.openbus.data_service.project.v1_01.ProjectDataViewFactory;
import tecgraf.openbus.data_service.project.v1_01.ProjectDataViewHelper;
import tecgraf.openbus.data_service.project.v1_01.ProjectItemDataViewFactory;
import tecgraf.openbus.data_service.project.v1_01.ProjectItemDataViewHelper;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.openbusservice.OpenBusServiceFacet;
import csbase.server.services.openbusservice.OpenBusServiceOffer;
import csbase.server.services.projectservice.ProjectService;

/**
 * 
 * Cria a configurao para o DataService da verso 1.1
 * 
 * @author Tecgraf PUC-Rio
 */
public class DataServiceOffer implements OpenBusServiceOffer {

  @Override
  public OpenBusServiceFacet[] getFacets() {
    IDataServiceServant dataServiceServant = new IDataServiceServant();
    IHierarchicalManagementDataServiceServant managementServiceServant =
      new IHierarchicalManagementDataServiceServant();
    IProjectNavigationDataServiceServant navigationServiceServant =
      new IProjectNavigationDataServiceServant();
    IHierarchicalTransferDataServiceServant transferServiceServant =
      new IHierarchicalTransferDataServiceServant();
    return new OpenBusServiceFacet[] {
        new OpenBusServiceFacet("dataservice_v1_1", IDataServiceHelper.id(),
          dataServiceServant),
        new OpenBusServiceFacet("managementdataservice_v1_1",
          IHierarchicalManagementDataServiceHelper.id(),
          managementServiceServant),
        new OpenBusServiceFacet("navigationdataservice_v1_1",
          IHierarchicalNavigationDataServiceHelper.id(),
          navigationServiceServant),
        new OpenBusServiceFacet("transferdataservice_v1_1",
          IHierarchicalTransferDataServiceHelper.id(), transferServiceServant),
        new OpenBusServiceFacet("projectnavigationdataservice_v1_1",
          IProjectNavigationDataServiceHelper.id(), navigationServiceServant) };
  }

  @Override
  public Properties getProperties() {
    String sourceId = ProjectService.getInstance().getSourceId();
    Properties props = new Properties();
    props.put(ProjectService.DATA_SOURCE_ID_PROPERTY_NAME, sourceId);

    return props;
  }

  @Override
  public void registerFactories() {
    org.omg.CORBA_2_3.ORB orb =
      (org.omg.CORBA_2_3.ORB) OpenBusService.getInstance().getORB();
    orb.register_value_factory(ProjectDataViewHelper.id(),
      new ProjectDataViewFactory());
    orb.register_value_factory(ProjectItemDataViewHelper.id(),
      new ProjectItemDataViewFactory());
    orb.register_value_factory(UnstructuredDataViewHelper.id(),
      new UnstructuredDataViewFactory());
  }
}
