/*
 * $Id$
 */

package csbase.server.services.sgaservice;

import java.io.IOException;
import java.util.StringTokenizer;

import tecgraf.javautils.core.externalcommand.ExternalCommand;
import csbase.logic.SGAInfo;
import csbase.server.Server;

/**
 * Thread representante de cada SGA. Essa thread  responsvel por calcular a
 * taxa de transferncia do servidor at o n executor.
 */

public class FindTransferRate extends Thread {
  private String iperfCommand;
  private long transferRate;
  private SGA sga;

  /**
   * Construtor da thread.
   * 
   * @param sga SGA cuja taxa de transferncia da rede est sendo avaliada.
   * @param netBenchDuration Durao, em segundos, do benchmark de rede.
   */
  public FindTransferRate(SGA sga, int netBenchDuration) {
    this.sga = sga;
    iperfCommand =
      "../sgad/bin/" + sga.getPlatformId() + "/iperf -t " + netBenchDuration
        + " -f K -c " + sga.getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void run() {
    ExternalCommand command;
    try {
      command = new ExternalCommand(iperfCommand);
      command.waitFor(true, false);
      String line = command.getStandardOutput(6);
      StringTokenizer st = new StringTokenizer(line, " ");
      while (st.hasMoreElements()) {
        String rate = st.nextToken();
        if (rate.equals("KBytes")) {
          rate = st.nextToken();
          transferRate = Long.parseLong(rate);
          break;
        }
      }
    }
    catch (NumberFormatException e) {
      Server.logSevereMessage(
        "Falha na coleta da taxa de transferncia de dados na rede.", e);
      transferRate = SGAInfo.NO_CAPACITY;
    }
    catch (IOException e) {
      Server.logSevereMessage(
        "Falha na coleta da taxa de transferncia de dados na rede.", e);
      transferRate = SGAInfo.NO_CAPACITY;
    }
    catch (InterruptedException e) {
      Server.logSevereMessage(
        "Coleta da taxa de transferncia de dados na rede foi interrompida", e);
      transferRate = SGAInfo.NO_CAPACITY;
    }
    sga.setTransferRate(transferRate);
  }
}
