/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v1_9;

import csbase.exception.OperationFailureException;
import csbase.logic.CommonClientProject;
import csbase.server.services.opendreamsservice.opendreams.v1_9.OpenDreamsSession;
import csbase.server.services.opendreamsservice.opendreams.v1_9.Session;
import csbase.server.services.projectservice.ProjectService;
import java.util.HashMap;
import java.util.Map;

public class SessionManager {
    private Map<SessionInfo, OpenDreamsSession> sessions = new HashMap<SessionInfo, OpenDreamsSession>();

    protected SessionManager() {
    }

    public Session getSession(String userId, String projectName) throws OperationFailureException {
        try {
            OpenDreamsSession session = this.sessions.get(new SessionInfo(userId, projectName));
            if (session == null) {
                session = new OpenDreamsSession();
            }
            ProjectService projectService = ProjectService.getInstance();
            Object projectId = projectService.getProjectId(userId, projectName);
            CommonClientProject project = projectService.openProject(projectId, false);
            session.setProject(project);
            session.setUser(userId);
            return session;
        }
        catch (Throwable e) {
            throw new OperationFailureException(e.getMessage());
        }
    }

    private static class SessionInfo {
        public final String user;
        public final String projectName;

        public SessionInfo(String user, String projectName) {
            this.user = user;
            this.projectName = projectName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionInfo other = (SessionInfo)SessionInfo.class.cast(o);
            return this.user.equals(other.user) && this.projectName.equals(other.projectName);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.projectName == null ? 0 : this.projectName.hashCode());
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            return result;
        }
    }
}

