/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_02;

import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_02.DataValidation;
import csbase.server.services.projectservice.v1_02.ProjectDataService;
import tecgraf.openbus.data_service.core.v1_02.AbsentViews;
import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataAlreadyExist;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.core.v1_02.UnavailableDataService;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalTransferDataServicePOA;
import tecgraf.openbus.data_service.hierarchical.v1_02.InvalidContainer;
import tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation;

public class IHierarchicalTransferDataServiceServant
extends IHierarchicalTransferDataServicePOA {
    public byte[] copyDataFrom(byte[] fSourceKey, byte[] fParentKey) throws UnavailableDataService, ServiceFailure, DataAlreadyExist, DataNotFound, DataAccessDenied, AbsentViews, UnsupportedOperation, InvalidDataKey, InvalidContainer {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            byte[] byArray = service.copyDataFrom(fSourceKey, fParentKey);
            return byArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public void updateDataFrom(byte[] fKey, byte[] fSourceKey) throws UnavailableDataService, ServiceFailure, DataNotFound, DataAccessDenied, AbsentViews, InvalidDataKey {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            service.updateDataFrom(fKey, fSourceKey);
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }
}

