/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket.notificationcenter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.EvictingQueue;
import csbase.logic.CommandInfo;
import csbase.logic.CommandNotification;
import csbase.logic.ProjectEvent;
import csbase.server.Server;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.restservice.websocket.CSBaseWebSocket;
import csbase.server.services.restservice.websocket.CSBaseWebSocketApplication;
import csbase.server.services.restservice.websocket.Message;
import csbase.server.services.restservice.websocket.Project;
import csbase.server.services.restservice.websocket.User;
import csbase.server.services.restservice.websocket.utils.PersistentMap;
import csbase.server.services.restservice.websocket.utils.WebSocketUtils;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.MessageBroker;
import csbase.util.messages.filters.BodyTypeFilter;
import ibase.common.ServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.json.JSONArray;
import org.json.JSONObject;
import tecgraf.javautils.core.filter.IFilter;

public class CSBaseNotificationCenter
extends CSBaseWebSocketApplication {
    private static final String NOTIFICATIONS_FILE = "wsnotifications.dat";
    private static final int NOTIFICATION_HISTORY_MAX_SIZE = 20;
    private PersistentMap<String, EvictingQueue<String>> notifications = new PersistentMap(WebSocketUtils.generatePath("wsnotifications.dat"));
    protected ConcurrentHashMap<String, Serializable> consumerIds = new ConcurrentHashMap();

    public CSBaseNotificationCenter() {
        this.setOnJobTerminateListener();
    }

    @Override
    public void onConnect(WebSocket socket) {
        super.onConnect(socket);
        if (socket instanceof CSBaseWebSocket) {
            CSBaseWebSocket ws = (CSBaseWebSocket)socket;
            this.notifications.putIfAbsent(ws.getUser().getLogin(), (EvictingQueue<String>)EvictingQueue.create((int)20));
            ws.send(this.createNotificationHistoryMessage(ws.getUser().getLogin()).toString());
        }
    }

    private void setOnJobTerminateListener() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MessageService.getInstance().setServerMessageListener((IMessageListener & Serializable)messages -> {
            for (csbase.util.messages.Message message : messages) {
                try {
                    Server.logInfoMessage("CommandNotification received in CSBaseNotificationCenter\n\t" + message.getBody().getClass().getSimpleName() + ": " + message.getBody());
                    if (!(message.getBody() instanceof CommandNotification)) continue;
                    CommandNotification commandNotification = (CommandNotification)message.getBody();
                    JSONObject content = new JSONObject(mapper.writeValueAsString((Object)commandNotification));
                    ProjectService ps = ProjectService.getInstance();
                    String project = ps.getProjectName(commandNotification.getProjectId());
                    content.put("project", (Object)project);
                    CommandInfo commandInfo = CommandPersistenceService.getInstance().getCommandInfo(commandNotification.getProjectId(), commandNotification.getCommandId().toString());
                    String user = commandInfo.getUserId().toString();
                    content.put("user", (Object)user);
                    Message commandTerminate = CSBaseNotificationCenter.createCommandTerminateMessage(content);
                    this.connections.forEach((targetUser, targetUserWebSockets) -> {
                        if (targetUser.equals(user)) {
                            this.notifications.compute((String)targetUser, (savedUser, savedUserNotifications) -> {
                                savedUserNotifications.add((Object)content.toString());
                                return savedUserNotifications;
                            });
                            Server.logInfoMessage("Sending notification for user " + user + " " + targetUserWebSockets.size() + " connections");
                            this.broadcaster.broadcast((Iterable)targetUserWebSockets, commandTerminate.toString());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Server.logSevereMessage("Error processing Message " + message + "\n\tMessage body: " + message.getBody(), e);
                }
            }
        }, (IFilter<csbase.util.messages.Message>)new BodyTypeFilter(CommandNotification.class));
    }

    private static Message createCommandTerminateMessage(JSONObject content) throws JsonProcessingException {
        Message commandTerminate = new Message();
        commandTerminate.setType("cmdtmt");
        commandTerminate.setContent(content);
        return commandTerminate;
    }

    private Message createNotificationHistoryMessage(String user) {
        JSONArray jsonArray = new JSONArray();
        this.notifications.get(user).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        Message history = new Message();
        history.setType("nhist");
        history.setContent(jsonArray);
        return history;
    }

    @Override
    public void onMessage(WebSocket websocket, String json) {
        try {
            CSBaseWebSocket ws = (CSBaseWebSocket)websocket;
            Message incomingMessage = new Message(json);
            incomingMessage.setUser(ws.getUser());
            if (incomingMessage.isProjectChange().booleanValue()) {
                Object content = incomingMessage.getContent();
                Project project = content != null ? new Project((JSONObject)content) : null;
                ws.setProject(project);
                this.connections.compute(ws.getUser().getLogin(), (user, userWebSockets) -> {
                    userWebSockets.removeIf(userWebSocket -> userWebSocket.getId().equals(ws.getId()));
                    userWebSockets.add(ws);
                    return userWebSockets;
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Server.logSevereMessage("Error processing message " + json + " sent by " + (Object)((Object)((CSBaseWebSocket)websocket).getUser()), e);
        }
    }

    @Override
    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
        CSBaseWebSocket ws = (CSBaseWebSocket)super.createSocket(handler, requestPacket, listeners);
        if (this.consumerIds.get(ws.getUser().getLogin()) == null) {
            MessageBroker broker = Server.getInstance().getMessageBroker();
            Serializable consumerId = broker.createConsumerId();
            broker.setMessageListener(ws.getUser().getLogin(), consumerId, (IMessageListener & Serializable)messages -> {
                User user = ws.getUser();
                ObjectMapper mapper = new ObjectMapper();
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                block5: for (csbase.util.messages.Message message : messages) {
                    try {
                        Server.logInfoMessage("ProjectEvent received in CSBaseNotificationCenter\n\t" + message.getBody().getClass().getSimpleName() + ": " + message.getBody());
                        if (!(message.getBody() instanceof ProjectEvent)) continue;
                        ProjectEvent projectEvent = (ProjectEvent)message.getBody();
                        switch (projectEvent.event) {
                            case 1: 
                            case 2: 
                            case 7: 
                            case 9: {
                                continue block5;
                            }
                            default: {
                                ArrayList sendList = new ArrayList();
                                ((List)this.connections.get(user.getLogin())).forEach(socket -> {
                                    if (socket.getProject() != null && projectEvent.projectId.equals(ServiceUtil.decodeFromBase64((String)socket.getProject().getId()))) {
                                        sendList.add(socket);
                                    }
                                });
                                if (sendList.size() <= 0) continue block5;
                                Message projectChange = CSBaseNotificationCenter.createProjectChangeMessage(user, ((CSBaseWebSocket)((Object)((Object)sendList.get(0)))).getProject());
                                this.broadcaster.broadcast(sendList, projectChange.toString());
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Server.logSevereMessage("Error processing Message " + message + "\n\tMessage body: " + message.getBody(), e);
                    }
                }
            }, (IFilter)new BodyTypeFilter(ProjectEvent.class));
            this.consumerIds.put(ws.getUser().getLogin(), consumerId);
        }
        return ws;
    }

    @Override
    public void onClose(WebSocket socket, DataFrame frame) {
        CSBaseWebSocket ws;
        List conn;
        super.onClose(socket, frame);
        if (socket instanceof CSBaseWebSocket && ((conn = (List)this.connections.get((ws = (CSBaseWebSocket)socket).getUser().getLogin())) == null || conn.isEmpty()) && this.consumerIds.get(ws.getUser().getLogin()) != null) {
            Server.getInstance().getMessageBroker().removeMessageListener(ws.getUser().getLogin(), this.consumerIds.get(ws.getUser().getLogin()));
            this.consumerIds.remove(ws.getUser().getLogin());
        }
    }

    private static Message createProjectChangeMessage(User user, Project project) {
        Message projectChange = new Message();
        projectChange.setType("prchg");
        projectChange.setUser(user);
        projectChange.setContent((Object)project);
        return projectChange;
    }
}

