/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sharedobjectservice.v1_00;

import csbase.logic.SharedObject;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_02.DataValidation;
import csbase.server.services.sharedobjectservice.SharedObjectService;
import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataKeyWrapper;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectDataView;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectDataViewImpl;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectServicePOA;

public class ISharedObjectServiceServant
extends SharedObjectServicePOA {
    private final String SHARED_OBJECT_DATAID_PREFIX = "SHAREDOBJECT:";

    public SharedObjectDataView getSharedObject(byte[] fKey) throws ServiceFailure, DataAccessDenied, DataNotFound, InvalidDataKey {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            SharedObjectDataViewImpl ret = null;
            DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
            DataValidation.checkDataKey(dataKey);
            if (dataKey.getDataId().contains("SHAREDOBJECT:")) {
                String category = dataKey.getDataId().split(":")[1];
                String user = dataKey.getDataId().split(":")[2];
                String objectName = dataKey.getDataId().split(":")[3];
                try {
                    SharedObject sharedObject = SharedObjectService.getInstance().getSharedObject(category, user, objectName);
                    if (sharedObject == null) {
                        throw new ServiceFailure("Usu\u00e1rio sem permiss\u00e3o de acesso ao shared object ou shared object n\u00e3o existente para: " + new String(fKey));
                    }
                    ret = new SharedObjectDataViewImpl(fKey, sharedObject.getContents().toString());
                }
                catch (Exception e) {
                    String reason = "";
                    if (e instanceof ServiceFailure) {
                        reason = ": " + ((ServiceFailure)e).fMessage;
                    }
                    throw new ServiceFailure(e.getMessage() + reason);
                }
            } else {
                throw new InvalidDataKey("SHAREDOBJECT: prefixo est\u00e1 faltando", (byte[][])new byte[][]{fKey});
            }
            SharedObjectDataViewImpl sharedObjectDataViewImpl = ret;
            return sharedObjectDataViewImpl;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }
}

