/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.notificationservice;

import csbase.logic.Notification;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

class NotificationContainer
implements Serializable {
    private final Hashtable<Object, ArrayList<Notification>> userHash = new Hashtable();

    final synchronized boolean clean(long delta) {
        return this.cleanNotifications(delta);
    }

    private boolean cleanNotifications(long delta) {
        Enumeration<ArrayList<Notification>> e = this.userHash.elements();
        while (e.hasMoreElements()) {
            ArrayList<Notification> v = e.nextElement();
            if (this.cleanVector(v, delta)) continue;
            return false;
        }
        return true;
    }

    private boolean cleanVector(ArrayList<Notification> vector, long delta) {
        long now = new Date().getTime();
        int i = 0;
        while (i < vector.size()) {
            Notification notif = vector.get(i);
            long ntime = notif.getCreationDate();
            if (notif.isVolatile() || Math.abs(now - ntime) > delta) {
                vector.remove(i);
                continue;
            }
            ++i;
        }
        return true;
    }

    final synchronized boolean dumpContainer(File file) {
        try {
            FileOutputStream fStream = new FileOutputStream(file);
            BufferedOutputStream bStream = new BufferedOutputStream(fStream);
            ObjectOutputStream outStream = new ObjectOutputStream(bStream);
            outStream.writeObject(this);
            outStream.flush();
            outStream.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean insertNotification(Object key, Notification notif) {
        ArrayList<Object> vector = this.userHash.get(key);
        if (vector == null) {
            ArrayList newVector = new ArrayList();
            this.userHash.put(key, newVector);
            vector = newVector;
        }
        return vector.add(notif);
    }

    final synchronized boolean insertUserNotification(Object userId, Notification notif) {
        return this.insertNotification(userId, notif);
    }

    private ArrayList<Notification> retrieveNotifications(Object key) {
        return this.userHash.remove(key);
    }

    final synchronized ArrayList<Notification> retrieveUserNotifications(Object userId) {
        return this.retrieveNotifications(userId);
    }

    final synchronized boolean userHasNotifications(Object userId) {
        ArrayList<Notification> notifications = this.userHash.get(userId);
        return notifications != null && !notifications.isEmpty();
    }

    NotificationContainer() {
    }
}

