/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice;

import csbase.logic.Role;
import csbase.logic.UserInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.server.Service;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.mailservice.MailService;
import csbase.server.services.restservice.RestService;
import ibase.authentication.AuthenticationService;
import ibase.authentication.ParseException;
import ibase.authentication.UnauthorizedException;
import ibase.common.NotFoundException;
import ibase.common.User;
import ibase.exception.InternalServiceException;
import java.rmi.RemoteException;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CSBaseAuthenticationServiceImpl
implements AuthenticationService {
    private static final String ADMIN_USER = "admin";
    public static final String ATTRIBUTE_USER_EMAIL = "userEmail";
    public static final String ATTRIBUTE_USER_NAME = "userName";
    public static final String ATTRIBUTE_USER_PASSWORD = "userPassword";

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public String parserToken(String token, Map<String, Object> attributes) throws ParseException {
        RestService restService = RestService.getInstance();
        try {
            String userId = restService.parserToken(token, attributes);
            if (userId != null) {
                Service.setUserId(userId);
            }
            return userId;
        }
        catch (csbase.exception.ParseException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public User login(String login, String password) throws UnauthorizedException {
        csbase.logic.User user = LoginService.getInstance().checkLogin(login, password);
        if (user == null) {
            throw new UnauthorizedException(RestService.getInstance().getString("RestService.unauthorized.login.error"));
        }
        return new User(user.getLogin(), user.getName(), Arrays.asList(user.getEmails()), Arrays.asList(user.getRoleIds()), null);
    }

    public User acceptNewUser(String userToken) throws UnauthorizedException {
        RestService restService = RestService.getInstance();
        try {
            Hashtable attributes = new Hashtable();
            String userId = restService.parserToken(userToken, attributes);
            String login = (String)attributes.get(ATTRIBUTE_USER_EMAIL);
            String email = (String)attributes.get(ATTRIBUTE_USER_EMAIL);
            String name = (String)attributes.get(ATTRIBUTE_USER_NAME);
            String password = (String)attributes.get(ATTRIBUTE_USER_PASSWORD);
            AdministrationService adminService = AdministrationService.getInstance();
            csbase.logic.User user = adminService.getUser(login);
            if (user == null) {
                this.createGuestUser(login, name, email, password);
                Object[] roleIds = new Object[]{this.getVisitorRole()};
                return new User(login, name, Arrays.asList(email), Arrays.asList(roleIds), null);
            }
            throw new UnauthorizedException(RestService.getInstance().getFormattedString("RestService.unauthorized.newuser.error", new Object[]{login}));
        }
        catch (csbase.exception.ParseException e) {
            throw new UnauthorizedException(e.getMessage());
        }
    }

    public User updateUser(User user) throws UnauthorizedException, NotFoundException {
        try {
            Service.setUserId(ADMIN_USER);
            AdministrationService administrationService = AdministrationService.getInstance();
            csbase.logic.User csbaseUser = administrationService.getUser(user.login);
            if (csbaseUser == null) {
                User user2 = null;
                return user2;
            }
            String[] currentEmails = csbaseUser.getEmails();
            user.emails.addAll(Arrays.asList(currentEmails));
            UserInfo userInfo = new UserInfo(csbaseUser.getUserInfo().getAttributes());
            userInfo.setAttribute("name", (Object)user.name);
            userInfo.setAttribute("emails", (Object)user.emails.toArray(new String[0]));
            userInfo.setAttribute("photoLink", (Object)user.avatarURL);
            Clock clock = Clock.systemDefaultZone();
            long lastUpdate = clock.millis();
            userInfo.setAttribute("lastUpdate", (Object)new Long(lastUpdate));
            administrationService.modifyUser(user.login, userInfo);
            User user3 = user;
            return user3;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        finally {
            Service.setUserId(null);
        }
    }

    public User acceptNewPassword(String userToken, String password) throws UnauthorizedException {
        RestService restService = RestService.getInstance();
        try {
            Hashtable attributes = new Hashtable();
            String userId = restService.parserToken(userToken, attributes);
            String login = (String)attributes.get(ATTRIBUTE_USER_EMAIL);
            AdministrationService adminService = AdministrationService.getInstance();
            csbase.logic.User user = adminService.getUser(login);
            if (user == null) {
                throw new UnauthorizedException(RestService.getInstance().getFormattedString("RestService.unauthorized.newuser.error", new Object[]{login}));
            }
            this.changeUserPassword(login, password);
            return new User(login, user.getName(), Arrays.asList(user.getEmails()), Arrays.asList(user.getRoleIds()), null);
        }
        catch (csbase.exception.ParseException e) {
            throw new UnauthorizedException(e.getMessage());
        }
    }

    public String createToken(String userId, Map<String, Object> attributes, Date expirationDate, Date issuedDate) throws UnauthorizedException {
        try {
            AdministrationService administrationService = AdministrationService.getInstance();
            RestService restService = RestService.getInstance();
            return restService.createToken(userId, attributes, expirationDate, issuedDate);
        }
        catch (Throwable e) {
            throw new UnauthorizedException(RestService.getInstance().getString("RestService.unauthorized.login.error"));
        }
    }

    public String createToken(String userId, Map<String, Object> attributes, Date expirationDate) throws UnauthorizedException {
        Instant now = Instant.now();
        return this.createToken(userId, attributes, expirationDate, Date.from(now));
    }

    public void validateRequestByEmail(String email, String link) {
        MailService service = MailService.getInstance();
        String[] recipient = new String[]{email};
        try {
            boolean sendEmail = service.sendMail(null, recipient, link);
            if (!sendEmail) {
                throw new UnauthorizedException(RestService.getInstance().getString("RestService.unauthorized.email.send.error"));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InternalServiceException(e);
        }
    }

    public void notifySupport(String content) {
        MailService service = MailService.getInstance();
        try {
            service.mailSupport(content);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void createGuestUser(String login, String name, String email, String password) throws UnauthorizedException {
        try {
            Service.setUserId(ADMIN_USER);
            AdministrationService administrationService = AdministrationService.getInstance();
            Object roleId = this.getVisitorRole();
            if (roleId == null) {
                throw new UnauthorizedException(RestService.getInstance().getString("RestService.no.visitor.role.login.error"));
            }
            Instant now = Instant.now();
            UserInfo newUserInfo = new UserInfo(login, name, new String[]{email}, new Object[]{roleId}, null, now.toEpochMilli());
            newUserInfo.setAttribute("password", (Object)password);
            administrationService.createUser(newUserInfo);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        finally {
            Service.setUserId(null);
        }
    }

    private void changeUserPassword(String login, String password) throws UnauthorizedException {
        try {
            Service.setUserId(ADMIN_USER);
            AdministrationService administrationService = AdministrationService.getInstance();
            csbase.logic.User user = administrationService.getUser(login);
            Instant now = Instant.now();
            UserInfo newUserInfo = new UserInfo(login, user.getName(), user.getEmails(), user.getRoleIds(), null, now.toEpochMilli());
            newUserInfo.setAttribute("password", (Object)password);
            administrationService.modifyUser(user.getId(), newUserInfo);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        finally {
            Service.setUserId(null);
        }
    }

    private Object getVisitorRole() {
        Service.setUserId(ADMIN_USER);
        AdministrationService administrationService = AdministrationService.getInstance();
        List<Role> allRoles = administrationService.getAllRoles();
        for (Role r : allRoles) {
            if (!r.getName().equals("VISITOR_ROLE")) continue;
            return r.getId();
        }
        return null;
    }
}

