/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.csfsservice;

import csbase.server.ServerException;
import csbase.server.plugin.service.sgaservice.ISGADataTransfer;
import csbase.server.plugin.service.sgaservice.SGADataTransferException;
import csbase.server.services.csfsservice.CSFSService;
import java.util.Map;
import java.util.Properties;

public class CSFSDataTransferMechanism
implements ISGADataTransfer {
    private Properties sgaProperties;
    private String csfsHost;
    private Integer csfsPort;

    public void setSGAProperties(Properties sgaProperties) {
        this.sgaProperties = sgaProperties;
    }

    public void close() throws Exception {
    }

    private String getHost() throws SGADataTransferException {
        if (this.csfsHost != null) {
            return this.csfsHost;
        }
        CSFSService csfsService = CSFSService.getInstance();
        if (csfsService == null || !csfsService.isActive()) {
            throw new SGADataTransferException("O servi\u00e7o CSFS n\u00e3o foi instanciado ou n\u00e3o est\u00e1 ativo.");
        }
        if (this.sgaProperties == null) {
            throw new SGADataTransferException("As propriedades do SGA n\u00e3o est\u00e3o dispon\u00edveis.");
        }
        this.csfsHost = this.sgaProperties.getProperty("csbase_csfs_host");
        if (this.csfsHost == null || this.csfsHost.isEmpty()) {
            this.csfsHost = null;
            throw new SGADataTransferException("A propriedade csbase_csfs_host do SGA " + this.sgaProperties.getProperty("csbase_sga_name") + " n\u00e3o est\u00e1 definida.");
        }
        return this.csfsHost;
    }

    private Integer getPort() throws SGADataTransferException {
        if (this.csfsPort != null) {
            return this.csfsPort;
        }
        CSFSService csfsService = CSFSService.getInstance();
        if (csfsService == null || !csfsService.isActive()) {
            throw new SGADataTransferException("O servi\u00e7o CSFS n\u00e3o foi instanciado ou n\u00e3o est\u00e1 ativo.");
        }
        if (this.sgaProperties == null) {
            throw new SGADataTransferException("As propriedades do SGA n\u00e3o est\u00e3o dispon\u00edveis.");
        }
        this.csfsPort = Integer.parseInt(this.sgaProperties.getProperty("csbase_csfs_port"));
        if (this.csfsPort == null) {
            throw new SGADataTransferException("A propriedade csbase_csfs_port do SGA " + this.sgaProperties.getProperty("csbase_sga_name") + " n\u00e3o est\u00e1 definida ou possui um valor inv\u00e1lido.");
        }
        return this.csfsPort;
    }

    public void copyTo(String[] sourcePath, String[] targetPath) throws SGADataTransferException {
        CSFSService csfsService = CSFSService.getInstance();
        try {
            csfsService.copyTo(this.getHost(), this.getPort(), sourcePath, targetPath);
        }
        catch (ServerException e) {
            throw new SGADataTransferException((Throwable)e);
        }
    }

    public void copyFrom(String[] remoteFilePath, String[] localFilePath) throws SGADataTransferException {
        CSFSService csfsService = CSFSService.getInstance();
        try {
            csfsService.copyFrom(this.getHost(), this.getPort(), remoteFilePath, localFilePath);
        }
        catch (ServerException e) {
            throw new SGADataTransferException((Throwable)e);
        }
    }

    public void createDirectory(String[] path) throws SGADataTransferException {
        CSFSService csfsService = CSFSService.getInstance();
        try {
            csfsService.createDirectory(this.getHost(), this.getPort(), path);
        }
        catch (ServerException e) {
            throw new SGADataTransferException((Throwable)e);
        }
    }

    public void remove(String[] path) throws SGADataTransferException {
        CSFSService csfsService = CSFSService.getInstance();
        try {
            csfsService.remove(this.getHost(), this.getPort(), path);
        }
        catch (ServerException e) {
            throw new SGADataTransferException((Throwable)e);
        }
    }

    public boolean checkExistence(String[] binaryDir) throws SGADataTransferException {
        CSFSService csfsService = CSFSService.getInstance();
        try {
            return csfsService.checkExistence(this.getHost(), this.getPort(), binaryDir);
        }
        catch (ServerException e) {
            throw new SGADataTransferException((Throwable)e);
        }
    }

    public String[] getProjectsRootPath() throws SGADataTransferException {
        CSFSService csfsService = CSFSService.getInstance();
        try {
            return csfsService.getCSFSProjectsRootPath();
        }
        catch (ServerException e) {
            throw new SGADataTransferException((Throwable)e);
        }
    }

    public String[] getAlgorithmsRootPath() throws SGADataTransferException {
        CSFSService csfsService = CSFSService.getInstance();
        try {
            return csfsService.getCSFSAlgorithmsRootPath();
        }
        catch (ServerException e) {
            throw new SGADataTransferException((Throwable)e);
        }
    }

    public Map<String[], Long> getRemoteTimestamps(String[] sandboxPath) throws SGADataTransferException {
        CSFSService csfsService = CSFSService.getInstance();
        try {
            return csfsService.getTimestamps(this.getHost(), this.getPort(), sandboxPath);
        }
        catch (ServerException e) {
            throw new SGADataTransferException((Throwable)e);
        }
    }

    public Map<String[], Long> getLocalTimestamps(String[] sandboxPath) throws SGADataTransferException {
        CSFSService csfsService = CSFSService.getInstance();
        try {
            return csfsService.getTimestamps(sandboxPath);
        }
        catch (ServerException e) {
            throw new SGADataTransferException((Throwable)e);
        }
    }
}

