/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.SGASet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BalancedCommandDistribution {
    Map<String, Integer> occupationMap = new HashMap<String, Integer>();

    public BalancedCommandDistribution(List<SGASet> servers) {
        for (SGASet sga : servers) {
            this.occupationMap.put(sga.getName(), 0);
        }
    }

    public SGASet chooseLightest(List<SGASet> servers) {
        SGASet choosedServer = this.getOccupationMininum(servers);
        this.occupationMap.put(choosedServer.getName(), this.occupationMap.get(choosedServer.getName()) + 1);
        return choosedServer;
    }

    private SGASet getOccupationMininum(List<SGASet> servers) {
        SGASet server = null;
        int occupation = 0;
        for (SGASet s : servers) {
            if (server != null && this.occupationMap.get(s.getName()) >= occupation || s == null) continue;
            server = s;
            occupation = this.occupationMap.get(s.getName());
        }
        return server;
    }
}

